package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PodConditionBuilder extends PodConditionFluentImpl<PodConditionBuilder> implements VisitableBuilder<PodCondition,PodConditionBuilder>{

     PodConditionFluent<?> fluent;
public PodConditionBuilder(){
    this(new PodCondition());
}
public PodConditionBuilder( PodConditionFluent<?> fluent ){
    this(fluent, new PodCondition());
}
public PodConditionBuilder( PodConditionFluent<?> fluent , PodCondition instance ){
    this.fluent = fluent; fluent.withLastProbeTime(instance.getLastProbeTime()); fluent.withLastTransitionTime(instance.getLastTransitionTime()); fluent.withMessage(instance.getMessage()); fluent.withReason(instance.getReason()); fluent.withStatus(instance.getStatus()); fluent.withType(instance.getType()); 
}
public PodConditionBuilder( PodCondition instance ){
    this.fluent = this; this.withLastProbeTime(instance.getLastProbeTime()); this.withLastTransitionTime(instance.getLastTransitionTime()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); this.withType(instance.getType()); 
}

public PodCondition build(){
    PodCondition buildable = new PodCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PodConditionBuilder that = (PodConditionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
