package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PodFluentImpl<A extends PodFluent<A>> extends BaseFluent<A> implements PodFluent<A>{

     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PodSpec, ?> spec;     VisitableBuilder<PodStatus, ?> status;
public PodFluentImpl(){
    
}
public PodFluentImpl( Pod instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); this.withStatus(instance.getStatus()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PodSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public A withSpec( PodSpec spec){
    if (spec!=null){ this.spec= new PodSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }
    public SpecNested<A> withNewSpec(){
    return new SpecNestedImpl();
    }
    public SpecNested<A> withNewSpecLike( PodSpec item){
    return new SpecNestedImpl(item);
    }
    public SpecNested<A> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public PodStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public A withStatus( PodStatus status){
    if (status!=null){ this.status= new PodStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }
    public StatusNested<A> withNewStatus(){
    return new StatusNestedImpl();
    }
    public StatusNested<A> withNewStatusLike( PodStatus item){
    return new StatusNestedImpl(item);
    }
    public StatusNested<A> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodFluentImpl that = (PodFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) PodFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNestedImpl<N> extends PodSpecFluentImpl<SpecNested<N>> implements SpecNested<N>{

        private final PodSpecBuilder builder;
    
             SpecNestedImpl (){
        this.builder = new PodSpecBuilder(this);
        }
             SpecNestedImpl ( PodSpec item){
        this.builder = new PodSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) PodFluentImpl.this.withSpec(builder.build());
        }
    
}
    public class StatusNestedImpl<N> extends PodStatusFluentImpl<StatusNested<N>> implements StatusNested<N>{

        private final PodStatusBuilder builder;
    
             StatusNestedImpl (){
        this.builder = new PodStatusBuilder(this);
        }
             StatusNestedImpl ( PodStatus item){
        this.builder = new PodStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) PodFluentImpl.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
