package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PodSecurityContextFluent<A extends PodSecurityContextFluent<A>> extends Fluent<A>{


    public Long getFsGroup();    public A withFsGroup( Long fsGroup);    public Boolean isRunAsNonRoot();    public A withRunAsNonRoot( Boolean runAsNonRoot);    public Long getRunAsUser();    public A withRunAsUser( Long runAsUser);    public SELinuxOptions getSeLinuxOptions();    public A withSeLinuxOptions( SELinuxOptions seLinuxOptions);    public SeLinuxOptionsNested<A> withNewSeLinuxOptions();    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike( SELinuxOptions item);    public SeLinuxOptionsNested<A> editSeLinuxOptions();    public A withNewSeLinuxOptions( String level,  String role,  String type,  String user);    public A addToSupplementalGroups( Long ...items);    public A removeFromSupplementalGroups( Long ...items);    public List<Long> getSupplementalGroups();    public A withSupplementalGroups( List<Long> supplementalGroups);    public A withSupplementalGroups( Long ...supplementalGroups);
    public interface SeLinuxOptionsNested<N> extends Nested<N>,SELinuxOptionsFluent<SeLinuxOptionsNested<N>>{
            public N endSeLinuxOptions();            public N and();        
}


}
