package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class PodSecurityContextFluentImpl<A extends PodSecurityContextFluent<A>> extends BaseFluent<A> implements PodSecurityContextFluent<A>{

     Long fsGroup;     Boolean runAsNonRoot;     Long runAsUser;     VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;     List<Long> supplementalGroups = new ArrayList();
public PodSecurityContextFluentImpl(){
    
}
public PodSecurityContextFluentImpl( PodSecurityContext instance ){
    this.withFsGroup(instance.getFsGroup()); this.withRunAsNonRoot(instance.getRunAsNonRoot()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxOptions(instance.getSeLinuxOptions()); this.withSupplementalGroups(instance.getSupplementalGroups()); 
}

    public Long getFsGroup(){
    return this.fsGroup;
    }
    public A withFsGroup( Long fsGroup){
    this.fsGroup=fsGroup; return (A) this;
    }
    public Boolean isRunAsNonRoot(){
    return this.runAsNonRoot;
    }
    public A withRunAsNonRoot( Boolean runAsNonRoot){
    this.runAsNonRoot=runAsNonRoot; return (A) this;
    }
    public Long getRunAsUser(){
    return this.runAsUser;
    }
    public A withRunAsUser( Long runAsUser){
    this.runAsUser=runAsUser; return (A) this;
    }
    public SELinuxOptions getSeLinuxOptions(){
    return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }
    public A withSeLinuxOptions( SELinuxOptions seLinuxOptions){
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (A) this;
    }
    public SeLinuxOptionsNested<A> withNewSeLinuxOptions(){
    return new SeLinuxOptionsNestedImpl();
    }
    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike( SELinuxOptions item){
    return new SeLinuxOptionsNestedImpl(item);
    }
    public SeLinuxOptionsNested<A> editSeLinuxOptions(){
    return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }
    public A withNewSeLinuxOptions( String level,  String role,  String type,  String user){
    return withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }
    public A addToSupplementalGroups( Long ...items){
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }
    public A removeFromSupplementalGroups( Long ...items){
    for (Long item : items) {this.supplementalGroups.remove(item);} return (A)this;
    }
    public List<Long> getSupplementalGroups(){
    return this.supplementalGroups;
    }
    public A withSupplementalGroups( List<Long> supplementalGroups){
    this.supplementalGroups.clear();if (supplementalGroups != null) {for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} return (A) this;
    }
    public A withSupplementalGroups( Long ...supplementalGroups){
    this.supplementalGroups.clear(); if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl) o;
if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
return true;

    }

    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<SeLinuxOptionsNested<N>> implements SeLinuxOptionsNested<N>{

        private final SELinuxOptionsBuilder builder;
    
             SeLinuxOptionsNestedImpl (){
        this.builder = new SELinuxOptionsBuilder(this);
        }
             SeLinuxOptionsNestedImpl ( SELinuxOptions item){
        this.builder = new SELinuxOptionsBuilder(this, item);
        }
    
            public N endSeLinuxOptions(){
            return and();
        }
            public N and(){
            return (N) PodSecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
        }
    
}


}
