package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;
import java.util.List;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>> extends BaseFluent<A> implements PodSpecFluent<A>{

     Long activeDeadlineSeconds;     List<VisitableBuilder<Container, ?>> containers = new ArrayList();     String dnsPolicy;     String host;     Boolean hostIPC;     Boolean hostNetwork;     Boolean hostPID;     List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();     String nodeName;     Map<String, String> nodeSelector = new HashMap();     String restartPolicy;     VisitableBuilder<PodSecurityContext, ?> securityContext;     String serviceAccount;     String serviceAccountName;     Long terminationGracePeriodSeconds;     List<VisitableBuilder<Volume, ?>> volumes = new ArrayList();
public PodSpecFluentImpl(){
    
}
public PodSpecFluentImpl( PodSpec instance ){
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); this.withContainers(instance.getContainers()); this.withDnsPolicy(instance.getDnsPolicy()); this.withHost(instance.getHost()); this.withHostIPC(instance.getHostIPC()); this.withHostNetwork(instance.getHostNetwork()); this.withHostPID(instance.getHostPID()); this.withImagePullSecrets(instance.getImagePullSecrets()); this.withNodeName(instance.getNodeName()); this.withNodeSelector(instance.getNodeSelector()); this.withRestartPolicy(instance.getRestartPolicy()); this.withSecurityContext(instance.getSecurityContext()); this.withServiceAccount(instance.getServiceAccount()); this.withServiceAccountName(instance.getServiceAccountName()); this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); this.withVolumes(instance.getVolumes()); 
}

    public Long getActiveDeadlineSeconds(){
    return this.activeDeadlineSeconds;
    }
    public A withActiveDeadlineSeconds( Long activeDeadlineSeconds){
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }
    public A addToContainers( Container ...items){
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (A)this;
    }
    public A removeFromContainers( Container ...items){
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.remove(builder);this.containers.remove(builder);} return (A)this;
    }
    public List<Container> getContainers(){
    return build(containers);
    }
    public A withContainers( List<Container> containers){
    this.containers.clear();if (containers != null) {for (Container item : containers){this.addToContainers(item);}} return (A) this;
    }
    public A withContainers( Container ...containers){
    this.containers.clear(); if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }
    public ContainersNested<A> addNewContainer(){
    return new ContainersNestedImpl();
    }
    public ContainersNested<A> addNewContainerLike( Container item){
    return new ContainersNestedImpl(item);
    }
    public String getDnsPolicy(){
    return this.dnsPolicy;
    }
    public A withDnsPolicy( String dnsPolicy){
    this.dnsPolicy=dnsPolicy; return (A) this;
    }
    public String getHost(){
    return this.host;
    }
    public A withHost( String host){
    this.host=host; return (A) this;
    }
    public Boolean isHostIPC(){
    return this.hostIPC;
    }
    public A withHostIPC( Boolean hostIPC){
    this.hostIPC=hostIPC; return (A) this;
    }
    public Boolean isHostNetwork(){
    return this.hostNetwork;
    }
    public A withHostNetwork( Boolean hostNetwork){
    this.hostNetwork=hostNetwork; return (A) this;
    }
    public Boolean isHostPID(){
    return this.hostPID;
    }
    public A withHostPID( Boolean hostPID){
    this.hostPID=hostPID; return (A) this;
    }
    public A addToImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }
    public A removeFromImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.remove(builder);this.imagePullSecrets.remove(builder);} return (A)this;
    }
    public List<LocalObjectReference> getImagePullSecrets(){
    return build(imagePullSecrets);
    }
    public A withImagePullSecrets( List<LocalObjectReference> imagePullSecrets){
    this.imagePullSecrets.clear();if (imagePullSecrets != null) {for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} return (A) this;
    }
    public A withImagePullSecrets( LocalObjectReference ...imagePullSecrets){
    this.imagePullSecrets.clear(); if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }
    public ImagePullSecretsNested<A> addNewImagePullSecret(){
    return new ImagePullSecretsNestedImpl();
    }
    public ImagePullSecretsNested<A> addNewImagePullSecretLike( LocalObjectReference item){
    return new ImagePullSecretsNestedImpl(item);
    }
    public A addNewImagePullSecret( String name){
    return addToImagePullSecrets(new LocalObjectReference(name));
    }
    public String getNodeName(){
    return this.nodeName;
    }
    public A withNodeName( String nodeName){
    this.nodeName=nodeName; return (A) this;
    }
    public A addToNodeSelector( String key,  String value){
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }
    public A addToNodeSelector( Map<String, String> map){
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }
    public A removeFromNodeSelector( String key){
    if(key != null) {this.nodeSelector.remove(key);} return (A)this;
    }
    public A removeFromNodeSelector( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.nodeSelector.remove(key);}} return (A)this;
    }
    public Map<String, String> getNodeSelector(){
    return this.nodeSelector;
    }
    public A withNodeSelector( Map<String, String> nodeSelector){
    this.nodeSelector.clear();if (nodeSelector != null) {this.nodeSelector.putAll(nodeSelector);} return (A) this;
    }
    public String getRestartPolicy(){
    return this.restartPolicy;
    }
    public A withRestartPolicy( String restartPolicy){
    this.restartPolicy=restartPolicy; return (A) this;
    }
    public PodSecurityContext getSecurityContext(){
    return this.securityContext!=null?this.securityContext.build():null;
    }
    public A withSecurityContext( PodSecurityContext securityContext){
    if (securityContext!=null){ this.securityContext= new PodSecurityContextBuilder(securityContext); _visitables.add(this.securityContext);} return (A) this;
    }
    public SecurityContextNested<A> withNewSecurityContext(){
    return new SecurityContextNestedImpl();
    }
    public SecurityContextNested<A> withNewSecurityContextLike( PodSecurityContext item){
    return new SecurityContextNestedImpl(item);
    }
    public SecurityContextNested<A> editSecurityContext(){
    return withNewSecurityContextLike(getSecurityContext());
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public A withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (A) this;
    }
    public String getServiceAccountName(){
    return this.serviceAccountName;
    }
    public A withServiceAccountName( String serviceAccountName){
    this.serviceAccountName=serviceAccountName; return (A) this;
    }
    public Long getTerminationGracePeriodSeconds(){
    return this.terminationGracePeriodSeconds;
    }
    public A withTerminationGracePeriodSeconds( Long terminationGracePeriodSeconds){
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
    }
    public A addToVolumes( Volume ...items){
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (A)this;
    }
    public A removeFromVolumes( Volume ...items){
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.volumes.remove(builder);} return (A)this;
    }
    public List<Volume> getVolumes(){
    return build(volumes);
    }
    public A withVolumes( List<Volume> volumes){
    this.volumes.clear();if (volumes != null) {for (Volume item : volumes){this.addToVolumes(item);}} return (A) this;
    }
    public A withVolumes( Volume ...volumes){
    this.volumes.clear(); if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }
    public VolumesNested<A> addNewVolume(){
    return new VolumesNestedImpl();
    }
    public VolumesNested<A> addNewVolumeLike( Volume item){
    return new VolumesNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodSpecFluentImpl that = (PodSpecFluentImpl) o;
if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
return true;

    }

    public class ContainersNestedImpl<N> extends ContainerFluentImpl<ContainersNested<N>> implements ContainersNested<N>{

        private final ContainerBuilder builder;
    
             ContainersNestedImpl (){
        this.builder = new ContainerBuilder(this);
        }
             ContainersNestedImpl ( Container item){
        this.builder = new ContainerBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.addToContainers(builder.build());
        }
            public N endContainer(){
            return and();
        }
    
}
    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<ImagePullSecretsNested<N>> implements ImagePullSecretsNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             ImagePullSecretsNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             ImagePullSecretsNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.addToImagePullSecrets(builder.build());
        }
            public N endImagePullSecret(){
            return and();
        }
    
}
    public class SecurityContextNestedImpl<N> extends PodSecurityContextFluentImpl<SecurityContextNested<N>> implements SecurityContextNested<N>{

        private final PodSecurityContextBuilder builder;
    
             SecurityContextNestedImpl (){
        this.builder = new PodSecurityContextBuilder(this);
        }
             SecurityContextNestedImpl ( PodSecurityContext item){
        this.builder = new PodSecurityContextBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.withSecurityContext(builder.build());
        }
            public N endSecurityContext(){
            return and();
        }
    
}
    public class VolumesNestedImpl<N> extends VolumeFluentImpl<VolumesNested<N>> implements VolumesNested<N>{

        private final VolumeBuilder builder;
    
             VolumesNestedImpl (){
        this.builder = new VolumeBuilder(this);
        }
             VolumesNestedImpl ( Volume item){
        this.builder = new VolumeBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.addToVolumes(builder.build());
        }
            public N endVolume(){
            return and();
        }
    
}


}
