
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "conditions",
    "containerStatuses",
    "hostIP",
    "message",
    "phase",
    "podIP",
    "reason",
    "startTime"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PodStatus {

    /**
     * 
     * 
     */
    @JsonProperty("conditions")
    @Valid
    private List<PodCondition> conditions = new ArrayList<PodCondition>();
    /**
     * 
     * 
     */
    @JsonProperty("containerStatuses")
    @Valid
    private List<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
    /**
     * 
     * 
     */
    @JsonProperty("hostIP")
    private String hostIP;
    /**
     * 
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * 
     * 
     */
    @JsonProperty("phase")
    private String phase;
    /**
     * 
     * 
     */
    @JsonProperty("podIP")
    private String podIP;
    /**
     * 
     * 
     */
    @JsonProperty("reason")
    private String reason;
    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    private String startTime;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PodStatus() {
    }

    /**
     * 
     * @param phase
     * @param reason
     * @param podIP
     * @param containerStatuses
     * @param hostIP
     * @param startTime
     * @param conditions
     * @param message
     */
    public PodStatus(List<PodCondition> conditions, List<ContainerStatus> containerStatuses, String hostIP, String message, String phase, String podIP, String reason, String startTime) {
        this.conditions = conditions;
        this.containerStatuses = containerStatuses;
        this.hostIP = hostIP;
        this.message = message;
        this.phase = phase;
        this.podIP = podIP;
        this.reason = reason;
        this.startTime = startTime;
    }

    /**
     * 
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<PodCondition> getConditions() {
        return conditions;
    }

    /**
     * 
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<PodCondition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The containerStatuses
     */
    @JsonProperty("containerStatuses")
    public List<ContainerStatus> getContainerStatuses() {
        return containerStatuses;
    }

    /**
     * 
     * 
     * @param containerStatuses
     *     The containerStatuses
     */
    @JsonProperty("containerStatuses")
    public void setContainerStatuses(List<ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    /**
     * 
     * 
     * @return
     *     The hostIP
     */
    @JsonProperty("hostIP")
    public String getHostIP() {
        return hostIP;
    }

    /**
     * 
     * 
     * @param hostIP
     *     The hostIP
     */
    @JsonProperty("hostIP")
    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    /**
     * 
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * 
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public String getPhase() {
        return phase;
    }

    /**
     * 
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    /**
     * 
     * 
     * @return
     *     The podIP
     */
    @JsonProperty("podIP")
    public String getPodIP() {
        return podIP;
    }

    /**
     * 
     * 
     * @param podIP
     *     The podIP
     */
    @JsonProperty("podIP")
    public void setPodIP(String podIP) {
        this.podIP = podIP;
    }

    /**
     * 
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * 
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * 
     * 
     * @return
     *     The startTime
     */
    @JsonProperty("startTime")
    public String getStartTime() {
        return startTime;
    }

    /**
     * 
     * 
     * @param startTime
     *     The startTime
     */
    @JsonProperty("startTime")
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
