package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PodStatusFluent<A extends PodStatusFluent<A>> extends Fluent<A>{


    public A addToConditions( PodCondition ...items);    public A removeFromConditions( PodCondition ...items);    public List<PodCondition> getConditions();    public A withConditions( List<PodCondition> conditions);    public A withConditions( PodCondition ...conditions);    public ConditionsNested<A> addNewCondition();    public ConditionsNested<A> addNewConditionLike( PodCondition item);    public A addToContainerStatuses( ContainerStatus ...items);    public A removeFromContainerStatuses( ContainerStatus ...items);    public List<ContainerStatus> getContainerStatuses();    public A withContainerStatuses( List<ContainerStatus> containerStatuses);    public A withContainerStatuses( ContainerStatus ...containerStatuses);    public ContainerStatusesNested<A> addNewContainerStatuse();    public ContainerStatusesNested<A> addNewContainerStatuseLike( ContainerStatus item);    public String getHostIP();    public A withHostIP( String hostIP);    public String getMessage();    public A withMessage( String message);    public String getPhase();    public A withPhase( String phase);    public String getPodIP();    public A withPodIP( String podIP);    public String getReason();    public A withReason( String reason);    public String getStartTime();    public A withStartTime( String startTime);
    public interface ConditionsNested<N> extends Nested<N>,PodConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}

    public interface ContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<ContainerStatusesNested<N>>{
            public N endContainerStatuse();            public N and();        
}


}
