package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PodTemplateBuilder extends PodTemplateFluentImpl<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder>{

     PodTemplateFluent<?> fluent;
public PodTemplateBuilder(){
    this(new PodTemplate());
}
public PodTemplateBuilder( PodTemplateFluent<?> fluent ){
    this(fluent, new PodTemplate());
}
public PodTemplateBuilder( PodTemplateFluent<?> fluent , PodTemplate instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withTemplate(instance.getTemplate()); 
}
public PodTemplateBuilder( PodTemplate instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withTemplate(instance.getTemplate()); 
}

public PodTemplate build(){
    PodTemplate buildable = new PodTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getTemplate());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PodTemplateBuilder that = (PodTemplateBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
