package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ProbeFluentImpl<A extends ProbeFluent<A>> extends BaseFluent<A> implements ProbeFluent<A>{

     VisitableBuilder<ExecAction, ?> exec;     Integer failureThreshold;     VisitableBuilder<HTTPGetAction, ?> httpGet;     Integer initialDelaySeconds;     Integer periodSeconds;     Integer successThreshold;     VisitableBuilder<TCPSocketAction, ?> tcpSocket;     Integer timeoutSeconds;
public ProbeFluentImpl(){
    
}
public ProbeFluentImpl( Probe instance ){
    this.withExec(instance.getExec()); this.withFailureThreshold(instance.getFailureThreshold()); this.withHttpGet(instance.getHttpGet()); this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); this.withPeriodSeconds(instance.getPeriodSeconds()); this.withSuccessThreshold(instance.getSuccessThreshold()); this.withTcpSocket(instance.getTcpSocket()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}

    public ExecAction getExec(){
    return this.exec!=null?this.exec.build():null;
    }
    public A withExec( ExecAction exec){
    if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.add(this.exec);} return (A) this;
    }
    public ExecNested<A> withNewExec(){
    return new ExecNestedImpl();
    }
    public ExecNested<A> withNewExecLike( ExecAction item){
    return new ExecNestedImpl(item);
    }
    public ExecNested<A> editExec(){
    return withNewExecLike(getExec());
    }
    public Integer getFailureThreshold(){
    return this.failureThreshold;
    }
    public A withFailureThreshold( Integer failureThreshold){
    this.failureThreshold=failureThreshold; return (A) this;
    }
    public HTTPGetAction getHttpGet(){
    return this.httpGet!=null?this.httpGet.build():null;
    }
    public A withHttpGet( HTTPGetAction httpGet){
    if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.add(this.httpGet);} return (A) this;
    }
    public HttpGetNested<A> withNewHttpGet(){
    return new HttpGetNestedImpl();
    }
    public HttpGetNested<A> withNewHttpGetLike( HTTPGetAction item){
    return new HttpGetNestedImpl(item);
    }
    public HttpGetNested<A> editHttpGet(){
    return withNewHttpGetLike(getHttpGet());
    }
    public Integer getInitialDelaySeconds(){
    return this.initialDelaySeconds;
    }
    public A withInitialDelaySeconds( Integer initialDelaySeconds){
    this.initialDelaySeconds=initialDelaySeconds; return (A) this;
    }
    public Integer getPeriodSeconds(){
    return this.periodSeconds;
    }
    public A withPeriodSeconds( Integer periodSeconds){
    this.periodSeconds=periodSeconds; return (A) this;
    }
    public Integer getSuccessThreshold(){
    return this.successThreshold;
    }
    public A withSuccessThreshold( Integer successThreshold){
    this.successThreshold=successThreshold; return (A) this;
    }
    public TCPSocketAction getTcpSocket(){
    return this.tcpSocket!=null?this.tcpSocket.build():null;
    }
    public A withTcpSocket( TCPSocketAction tcpSocket){
    if (tcpSocket!=null){ this.tcpSocket= new TCPSocketActionBuilder(tcpSocket); _visitables.add(this.tcpSocket);} return (A) this;
    }
    public TcpSocketNested<A> withNewTcpSocket(){
    return new TcpSocketNestedImpl();
    }
    public TcpSocketNested<A> withNewTcpSocketLike( TCPSocketAction item){
    return new TcpSocketNestedImpl(item);
    }
    public TcpSocketNested<A> editTcpSocket(){
    return withNewTcpSocketLike(getTcpSocket());
    }
    public Integer getTimeoutSeconds(){
    return this.timeoutSeconds;
    }
    public A withTimeoutSeconds( Integer timeoutSeconds){
    this.timeoutSeconds=timeoutSeconds; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ProbeFluentImpl that = (ProbeFluentImpl) o;
if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
if (failureThreshold != null ? !failureThreshold.equals(that.failureThreshold) :that.failureThreshold != null) return false;
if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
if (initialDelaySeconds != null ? !initialDelaySeconds.equals(that.initialDelaySeconds) :that.initialDelaySeconds != null) return false;
if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
if (successThreshold != null ? !successThreshold.equals(that.successThreshold) :that.successThreshold != null) return false;
if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
return true;

    }

    public class ExecNestedImpl<N> extends ExecActionFluentImpl<ExecNested<N>> implements ExecNested<N>{

        private final ExecActionBuilder builder;
    
             ExecNestedImpl (){
        this.builder = new ExecActionBuilder(this);
        }
             ExecNestedImpl ( ExecAction item){
        this.builder = new ExecActionBuilder(this, item);
        }
    
            public N and(){
            return (N) ProbeFluentImpl.this.withExec(builder.build());
        }
            public N endExec(){
            return and();
        }
    
}
    public class HttpGetNestedImpl<N> extends HTTPGetActionFluentImpl<HttpGetNested<N>> implements HttpGetNested<N>{

        private final HTTPGetActionBuilder builder;
    
             HttpGetNestedImpl (){
        this.builder = new HTTPGetActionBuilder(this);
        }
             HttpGetNestedImpl ( HTTPGetAction item){
        this.builder = new HTTPGetActionBuilder(this, item);
        }
    
            public N endHttpGet(){
            return and();
        }
            public N and(){
            return (N) ProbeFluentImpl.this.withHttpGet(builder.build());
        }
    
}
    public class TcpSocketNestedImpl<N> extends TCPSocketActionFluentImpl<TcpSocketNested<N>> implements TcpSocketNested<N>{

        private final TCPSocketActionBuilder builder;
    
             TcpSocketNestedImpl (){
        this.builder = new TCPSocketActionBuilder(this);
        }
             TcpSocketNestedImpl ( TCPSocketAction item){
        this.builder = new TCPSocketActionBuilder(this, item);
        }
    
            public N and(){
            return (N) ProbeFluentImpl.this.withTcpSocket(builder.build());
        }
            public N endTcpSocket(){
            return and();
        }
    
}


}
