package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ReplicationControllerFluent<A extends ReplicationControllerFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public ReplicationControllerSpec getSpec();    public A withSpec( ReplicationControllerSpec spec);    public SpecNested<A> withNewSpec();    public SpecNested<A> withNewSpecLike( ReplicationControllerSpec item);    public SpecNested<A> editSpec();    public ReplicationControllerStatus getStatus();    public A withStatus( ReplicationControllerStatus status);    public StatusNested<A> withNewStatus();    public StatusNested<A> withNewStatusLike( ReplicationControllerStatus item);    public StatusNested<A> editStatus();    public A withNewStatus( Integer fullyLabeledReplicas,  Long observedGeneration,  Integer replicas);
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>,ReplicationControllerSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>,ReplicationControllerStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
