package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ReplicationControllerSpecBuilder extends ReplicationControllerSpecFluentImpl<ReplicationControllerSpecBuilder> implements VisitableBuilder<ReplicationControllerSpec,ReplicationControllerSpecBuilder>{

     ReplicationControllerSpecFluent<?> fluent;
public ReplicationControllerSpecBuilder(){
    this(new ReplicationControllerSpec());
}
public ReplicationControllerSpecBuilder( ReplicationControllerSpecFluent<?> fluent ){
    this(fluent, new ReplicationControllerSpec());
}
public ReplicationControllerSpecBuilder( ReplicationControllerSpecFluent<?> fluent , ReplicationControllerSpec instance ){
    this.fluent = fluent; fluent.withReplicas(instance.getReplicas()); fluent.withSelector(instance.getSelector()); fluent.withTemplate(instance.getTemplate()); 
}
public ReplicationControllerSpecBuilder( ReplicationControllerSpec instance ){
    this.fluent = this; this.withReplicas(instance.getReplicas()); this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); 
}

public ReplicationControllerSpec build(){
    ReplicationControllerSpec buildable = new ReplicationControllerSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ReplicationControllerSpecBuilder that = (ReplicationControllerSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
