package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ResourceQuotaSpecFluentImpl<A extends ResourceQuotaSpecFluent<A>> extends BaseFluent<A> implements ResourceQuotaSpecFluent<A>{

     Map<String, Quantity> hard = new HashMap();     List<String> scopes = new ArrayList();
public ResourceQuotaSpecFluentImpl(){
    
}
public ResourceQuotaSpecFluentImpl( ResourceQuotaSpec instance ){
    this.withHard(instance.getHard()); this.withScopes(instance.getScopes()); 
}

    public A addToHard( String key,  Quantity value){
    if(key != null && value != null) {this.hard.put(key, value);} return (A)this;
    }
    public A addToHard( Map<String, Quantity> map){
    if(map != null) { this.hard.putAll(map);} return (A)this;
    }
    public A removeFromHard( String key){
    if(key != null) {this.hard.remove(key);} return (A)this;
    }
    public A removeFromHard( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.hard.remove(key);}} return (A)this;
    }
    public Map<String, Quantity> getHard(){
    return this.hard;
    }
    public A withHard( Map<String, Quantity> hard){
    this.hard.clear();if (hard != null) {this.hard.putAll(hard);} return (A) this;
    }
    public A addToScopes( String ...items){
    for (String item : items) {this.scopes.add(item);} return (A)this;
    }
    public A removeFromScopes( String ...items){
    for (String item : items) {this.scopes.remove(item);} return (A)this;
    }
    public List<String> getScopes(){
    return this.scopes;
    }
    public A withScopes( List<String> scopes){
    this.scopes.clear();if (scopes != null) {for (String item : scopes){this.addToScopes(item);}} return (A) this;
    }
    public A withScopes( String ...scopes){
    this.scopes.clear(); if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ResourceQuotaSpecFluentImpl that = (ResourceQuotaSpecFluentImpl) o;
if (hard != null ? !hard.equals(that.hard) :that.hard != null) return false;
if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
return true;

    }



}
