package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ResourceRequirementsBuilder extends ResourceRequirementsFluentImpl<ResourceRequirementsBuilder> implements VisitableBuilder<ResourceRequirements,ResourceRequirementsBuilder>{

     ResourceRequirementsFluent<?> fluent;
public ResourceRequirementsBuilder(){
    this(new ResourceRequirements());
}
public ResourceRequirementsBuilder( ResourceRequirementsFluent<?> fluent ){
    this(fluent, new ResourceRequirements());
}
public ResourceRequirementsBuilder( ResourceRequirementsFluent<?> fluent , ResourceRequirements instance ){
    this.fluent = fluent; fluent.withLimits(instance.getLimits()); fluent.withRequests(instance.getRequests()); 
}
public ResourceRequirementsBuilder( ResourceRequirements instance ){
    this.fluent = this; this.withLimits(instance.getLimits()); this.withRequests(instance.getRequests()); 
}

public ResourceRequirements build(){
    ResourceRequirements buildable = new ResourceRequirements(fluent.getLimits(),fluent.getRequests());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ResourceRequirementsBuilder that = (ResourceRequirementsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
