package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class SecurityContextConstraintsBuilder extends SecurityContextConstraintsFluentImpl<SecurityContextConstraintsBuilder> implements VisitableBuilder<SecurityContextConstraints,SecurityContextConstraintsBuilder>{

     SecurityContextConstraintsFluent<?> fluent;
public SecurityContextConstraintsBuilder(){
    this(new SecurityContextConstraints());
}
public SecurityContextConstraintsBuilder( SecurityContextConstraintsFluent<?> fluent ){
    this(fluent, new SecurityContextConstraints());
}
public SecurityContextConstraintsBuilder( SecurityContextConstraintsFluent<?> fluent , SecurityContextConstraints instance ){
    this.fluent = fluent; fluent.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); fluent.withAllowHostIPC(instance.getAllowHostIPC()); fluent.withAllowHostNetwork(instance.getAllowHostNetwork()); fluent.withAllowHostPID(instance.getAllowHostPID()); fluent.withAllowHostPorts(instance.getAllowHostPorts()); fluent.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); fluent.withAllowedCapabilities(instance.getAllowedCapabilities()); fluent.withApiVersion(instance.getApiVersion()); fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); fluent.withFsGroup(instance.getFsGroup()); fluent.withGroups(instance.getGroups()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withPriority(instance.getPriority()); fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); fluent.withRunAsUser(instance.getRunAsUser()); fluent.withSeLinuxContext(instance.getSeLinuxContext()); fluent.withSupplementalGroups(instance.getSupplementalGroups()); fluent.withUsers(instance.getUsers()); fluent.withVolumes(instance.getVolumes()); 
}
public SecurityContextConstraintsBuilder( SecurityContextConstraints instance ){
    this.fluent = this; this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); this.withAllowHostIPC(instance.getAllowHostIPC()); this.withAllowHostNetwork(instance.getAllowHostNetwork()); this.withAllowHostPID(instance.getAllowHostPID()); this.withAllowHostPorts(instance.getAllowHostPorts()); this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); this.withAllowedCapabilities(instance.getAllowedCapabilities()); this.withApiVersion(instance.getApiVersion()); this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); this.withFsGroup(instance.getFsGroup()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withPriority(instance.getPriority()); this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxContext(instance.getSeLinuxContext()); this.withSupplementalGroups(instance.getSupplementalGroups()); this.withUsers(instance.getUsers()); this.withVolumes(instance.getVolumes()); 
}

public SecurityContextConstraints build(){
    SecurityContextConstraints buildable = new SecurityContextConstraints(fluent.isAllowHostDirVolumePlugin(),fluent.isAllowHostIPC(),fluent.isAllowHostNetwork(),fluent.isAllowHostPID(),fluent.isAllowHostPorts(),fluent.isAllowPrivilegedContainer(),fluent.getAllowedCapabilities(),fluent.getApiVersion(),fluent.getDefaultAddCapabilities(),fluent.getFsGroup(),fluent.getGroups(),fluent.getKind(),fluent.getMetadata(),fluent.getPriority(),fluent.isReadOnlyRootFilesystem(),fluent.getRequiredDropCapabilities(),fluent.getRunAsUser(),fluent.getSeLinuxContext(),fluent.getSupplementalGroups(),fluent.getUsers(),fluent.getVolumes());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SecurityContextConstraintsBuilder that = (SecurityContextConstraintsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
