package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ServicePortBuilder extends ServicePortFluentImpl<ServicePortBuilder> implements VisitableBuilder<ServicePort,ServicePortBuilder>{

     ServicePortFluent<?> fluent;
public ServicePortBuilder(){
    this(new ServicePort());
}
public ServicePortBuilder( ServicePortFluent<?> fluent ){
    this(fluent, new ServicePort());
}
public ServicePortBuilder( ServicePortFluent<?> fluent , ServicePort instance ){
    this.fluent = fluent; fluent.withName(instance.getName()); fluent.withNodePort(instance.getNodePort()); fluent.withPort(instance.getPort()); fluent.withProtocol(instance.getProtocol()); fluent.withTargetPort(instance.getTargetPort()); 
}
public ServicePortBuilder( ServicePort instance ){
    this.fluent = this; this.withName(instance.getName()); this.withNodePort(instance.getNodePort()); this.withPort(instance.getPort()); this.withProtocol(instance.getProtocol()); this.withTargetPort(instance.getTargetPort()); 
}

public ServicePort build(){
    ServicePort buildable = new ServicePort(fluent.getName(),fluent.getNodePort(),fluent.getPort(),fluent.getProtocol(),fluent.getTargetPort());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ServicePortBuilder that = (ServicePortBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
