package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;

public class StatusDetailsFluentImpl<A extends StatusDetailsFluent<A>> extends BaseFluent<A> implements StatusDetailsFluent<A>{

     List<VisitableBuilder<StatusCause, ?>> causes = new ArrayList();     String group;     String kind;     String name;     Integer retryAfterSeconds;
public StatusDetailsFluentImpl(){
    
}
public StatusDetailsFluentImpl( StatusDetails instance ){
    this.withCauses(instance.getCauses()); this.withGroup(instance.getGroup()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
}

    public A addToCauses( StatusCause ...items){
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.add(builder);this.causes.add(builder);} return (A)this;
    }
    public A removeFromCauses( StatusCause ...items){
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.remove(builder);this.causes.remove(builder);} return (A)this;
    }
    public List<StatusCause> getCauses(){
    return build(causes);
    }
    public A withCauses( List<StatusCause> causes){
    this.causes.clear();if (causes != null) {for (StatusCause item : causes){this.addToCauses(item);}} return (A) this;
    }
    public A withCauses( StatusCause ...causes){
    this.causes.clear(); if (causes != null) {for (StatusCause item :causes){ this.addToCauses(item);}} return (A) this;
    }
    public CausesNested<A> addNewCause(){
    return new CausesNestedImpl();
    }
    public CausesNested<A> addNewCauseLike( StatusCause item){
    return new CausesNestedImpl(item);
    }
    public A addNewCause( String field,  String message,  String reason){
    return addToCauses(new StatusCause(field, message, reason));
    }
    public String getGroup(){
    return this.group;
    }
    public A withGroup( String group){
    this.group=group; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public Integer getRetryAfterSeconds(){
    return this.retryAfterSeconds;
    }
    public A withRetryAfterSeconds( Integer retryAfterSeconds){
    this.retryAfterSeconds=retryAfterSeconds; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
StatusDetailsFluentImpl that = (StatusDetailsFluentImpl) o;
if (causes != null ? !causes.equals(that.causes) :that.causes != null) return false;
if (group != null ? !group.equals(that.group) :that.group != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (retryAfterSeconds != null ? !retryAfterSeconds.equals(that.retryAfterSeconds) :that.retryAfterSeconds != null) return false;
return true;

    }

    public class CausesNestedImpl<N> extends StatusCauseFluentImpl<CausesNested<N>> implements CausesNested<N>{

        private final StatusCauseBuilder builder;
    
             CausesNestedImpl (){
        this.builder = new StatusCauseBuilder(this);
        }
             CausesNestedImpl ( StatusCause item){
        this.builder = new StatusCauseBuilder(this, item);
        }
    
            public N endCause(){
            return and();
        }
            public N and(){
            return (N) StatusDetailsFluentImpl.this.addToCauses(builder.build());
        }
    
}


}
