package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface StatusFluent<A extends StatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public Integer getCode();    public A withCode( Integer code);    public StatusDetails getDetails();    public A withDetails( StatusDetails details);    public DetailsNested<A> withNewDetails();    public DetailsNested<A> withNewDetailsLike( StatusDetails item);    public DetailsNested<A> editDetails();    public String getKind();    public A withKind( String kind);    public String getMessage();    public A withMessage( String message);    public ListMeta getMetadata();    public A withMetadata( ListMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ListMeta item);    public MetadataNested<A> editMetadata();    public A withNewMetadata( String resourceVersion,  String selfLink);    public String getReason();    public A withReason( String reason);    public String getStatus();    public A withStatus( String status);
    public interface DetailsNested<N> extends Nested<N>,StatusDetailsFluent<DetailsNested<N>>{
            public N and();            public N endDetails();        
}

    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
