package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class TCPSocketActionFluentImpl<A extends TCPSocketActionFluent<A>> extends BaseFluent<A> implements TCPSocketActionFluent<A>{

     VisitableBuilder<IntOrString, ?> port;
public TCPSocketActionFluentImpl(){
    
}
public TCPSocketActionFluentImpl( TCPSocketAction instance ){
    this.withPort(instance.getPort()); 
}

    public IntOrString getPort(){
    return this.port!=null?this.port.build():null;
    }
    public A withPort( IntOrString port){
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (A) this;
    }
    public PortNested<A> withNewPort(){
    return new PortNestedImpl();
    }
    public PortNested<A> withNewPortLike( IntOrString item){
    return new PortNestedImpl(item);
    }
    public PortNested<A> editPort(){
    return withNewPortLike(getPort());
    }
    public A withNewPort( String strVal){
    return withPort(new IntOrString(strVal));
    }
    public A withNewPort( Integer intVal){
    return withPort(new IntOrString(intVal));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TCPSocketActionFluentImpl that = (TCPSocketActionFluentImpl) o;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
return true;

    }

    public class PortNestedImpl<N> extends IntOrStringFluentImpl<PortNested<N>> implements PortNested<N>{

        private final IntOrStringBuilder builder;
    
             PortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             PortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) TCPSocketActionFluentImpl.this.withPort(builder.build());
        }
    
}


}
