package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class VolumeMountFluentImpl<A extends VolumeMountFluent<A>> extends BaseFluent<A> implements VolumeMountFluent<A>{

     String mountPath;     String name;     Boolean readOnly;
public VolumeMountFluentImpl(){
    
}
public VolumeMountFluentImpl( VolumeMount instance ){
    this.withMountPath(instance.getMountPath()); this.withName(instance.getName()); this.withReadOnly(instance.getReadOnly()); 
}

    public String getMountPath(){
    return this.mountPath;
    }
    public A withMountPath( String mountPath){
    this.mountPath=mountPath; return (A) this;
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
VolumeMountFluentImpl that = (VolumeMountFluentImpl) o;
if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
return true;

    }



}
