package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class DaemonSetSpecFluentImpl<A extends DaemonSetSpecFluent<A>> extends BaseFluent<A> implements DaemonSetSpecFluent<A>{

     VisitableBuilder<LabelSelector, ?> selector;     VisitableBuilder<PodTemplateSpec, ?> template;
public DaemonSetSpecFluentImpl(){
    
}
public DaemonSetSpecFluentImpl( DaemonSetSpec instance ){
    this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); 
}

    public LabelSelector getSelector(){
    return this.selector!=null?this.selector.build():null;
    }
    public A withSelector( LabelSelector selector){
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }
    public SelectorNested<A> withNewSelector(){
    return new SelectorNestedImpl();
    }
    public SelectorNested<A> withNewSelectorLike( LabelSelector item){
    return new SelectorNestedImpl(item);
    }
    public SelectorNested<A> editSelector(){
    return withNewSelectorLike(getSelector());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public A withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }
    public TemplateNested<A> withNewTemplate(){
    return new TemplateNestedImpl();
    }
    public TemplateNested<A> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl(item);
    }
    public TemplateNested<A> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl) o;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
return true;

    }

    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<SelectorNested<N>> implements SelectorNested<N>{

        private final LabelSelectorBuilder builder;
    
             SelectorNestedImpl (){
        this.builder = new LabelSelectorBuilder(this);
        }
             SelectorNestedImpl ( LabelSelector item){
        this.builder = new LabelSelectorBuilder(this, item);
        }
    
            public N endSelector(){
            return and();
        }
            public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withSelector(builder.build());
        }
    
}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
        }
    
}


}
