package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DaemonSetStatusBuilder extends DaemonSetStatusFluentImpl<DaemonSetStatusBuilder> implements VisitableBuilder<DaemonSetStatus,DaemonSetStatusBuilder>{

     DaemonSetStatusFluent<?> fluent;
public DaemonSetStatusBuilder(){
    this(new DaemonSetStatus());
}
public DaemonSetStatusBuilder( DaemonSetStatusFluent<?> fluent ){
    this(fluent, new DaemonSetStatus());
}
public DaemonSetStatusBuilder( DaemonSetStatusFluent<?> fluent , DaemonSetStatus instance ){
    this.fluent = fluent; fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); fluent.withNumberMisscheduled(instance.getNumberMisscheduled()); 
}
public DaemonSetStatusBuilder( DaemonSetStatus instance ){
    this.fluent = this; this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
}

public DaemonSetStatus build(){
    DaemonSetStatus buildable = new DaemonSetStatus(fluent.getCurrentNumberScheduled(),fluent.getDesiredNumberScheduled(),fluent.getNumberMisscheduled());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DaemonSetStatusBuilder that = (DaemonSetStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
