package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface DeploymentSpecFluent<A extends DeploymentSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();    public A withMinReadySeconds( Integer minReadySeconds);    public Boolean isPaused();    public A withPaused( Boolean paused);    public Integer getReplicas();    public A withReplicas( Integer replicas);    public Integer getRevisionHistoryLimit();    public A withRevisionHistoryLimit( Integer revisionHistoryLimit);    public RollbackConfig getRollbackTo();    public A withRollbackTo( RollbackConfig rollbackTo);    public RollbackToNested<A> withNewRollbackTo();    public RollbackToNested<A> withNewRollbackToLike( RollbackConfig item);    public RollbackToNested<A> editRollbackTo();    public A withNewRollbackTo( Long revision);    public LabelSelector getSelector();    public A withSelector( LabelSelector selector);    public SelectorNested<A> withNewSelector();    public SelectorNested<A> withNewSelectorLike( LabelSelector item);    public SelectorNested<A> editSelector();    public DeploymentStrategy getStrategy();    public A withStrategy( DeploymentStrategy strategy);    public StrategyNested<A> withNewStrategy();    public StrategyNested<A> withNewStrategyLike( DeploymentStrategy item);    public StrategyNested<A> editStrategy();    public PodTemplateSpec getTemplate();    public A withTemplate( PodTemplateSpec template);    public TemplateNested<A> withNewTemplate();    public TemplateNested<A> withNewTemplateLike( PodTemplateSpec item);    public TemplateNested<A> editTemplate();
    public interface RollbackToNested<N> extends Nested<N>,RollbackConfigFluent<RollbackToNested<N>>{
            public N endRollbackTo();            public N and();        
}

    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<SelectorNested<N>>{
            public N endSelector();            public N and();        
}

    public interface StrategyNested<N> extends Nested<N>,DeploymentStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}

    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<TemplateNested<N>>{
            public N endTemplate();            public N and();        
}


}
