package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class DeploymentStrategyFluentImpl<A extends DeploymentStrategyFluent<A>> extends BaseFluent<A> implements DeploymentStrategyFluent<A>{

     VisitableBuilder<RollingUpdateDeployment, ?> rollingUpdate;     String type;
public DeploymentStrategyFluentImpl(){
    
}
public DeploymentStrategyFluentImpl( DeploymentStrategy instance ){
    this.withRollingUpdate(instance.getRollingUpdate()); this.withType(instance.getType()); 
}

    public RollingUpdateDeployment getRollingUpdate(){
    return this.rollingUpdate!=null?this.rollingUpdate.build():null;
    }
    public A withRollingUpdate( RollingUpdateDeployment rollingUpdate){
    if (rollingUpdate!=null){ this.rollingUpdate= new RollingUpdateDeploymentBuilder(rollingUpdate); _visitables.add(this.rollingUpdate);} return (A) this;
    }
    public RollingUpdateNested<A> withNewRollingUpdate(){
    return new RollingUpdateNestedImpl();
    }
    public RollingUpdateNested<A> withNewRollingUpdateLike( RollingUpdateDeployment item){
    return new RollingUpdateNestedImpl(item);
    }
    public RollingUpdateNested<A> editRollingUpdate(){
    return withNewRollingUpdateLike(getRollingUpdate());
    }
    public String getType(){
    return this.type;
    }
    public A withType( String type){
    this.type=type; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentStrategyFluentImpl that = (DeploymentStrategyFluentImpl) o;
if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
return true;

    }

    public class RollingUpdateNestedImpl<N> extends RollingUpdateDeploymentFluentImpl<RollingUpdateNested<N>> implements RollingUpdateNested<N>{

        private final RollingUpdateDeploymentBuilder builder;
    
             RollingUpdateNestedImpl (){
        this.builder = new RollingUpdateDeploymentBuilder(this);
        }
             RollingUpdateNestedImpl ( RollingUpdateDeployment item){
        this.builder = new RollingUpdateDeploymentBuilder(this, item);
        }
    
            public N endRollingUpdate(){
            return and();
        }
            public N and(){
            return (N) DeploymentStrategyFluentImpl.this.withRollingUpdate(builder.build());
        }
    
}


}
