package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class HTTPIngressPathFluentImpl<A extends HTTPIngressPathFluent<A>> extends BaseFluent<A> implements HTTPIngressPathFluent<A>{

     VisitableBuilder<IngressBackend, ?> backend;     String path;
public HTTPIngressPathFluentImpl(){
    
}
public HTTPIngressPathFluentImpl( HTTPIngressPath instance ){
    this.withBackend(instance.getBackend()); this.withPath(instance.getPath()); 
}

    public IngressBackend getBackend(){
    return this.backend!=null?this.backend.build():null;
    }
    public A withBackend( IngressBackend backend){
    if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.add(this.backend);} return (A) this;
    }
    public BackendNested<A> withNewBackend(){
    return new BackendNestedImpl();
    }
    public BackendNested<A> withNewBackendLike( IngressBackend item){
    return new BackendNestedImpl(item);
    }
    public BackendNested<A> editBackend(){
    return withNewBackendLike(getBackend());
    }
    public String getPath(){
    return this.path;
    }
    public A withPath( String path){
    this.path=path; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HTTPIngressPathFluentImpl that = (HTTPIngressPathFluentImpl) o;
if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
return true;

    }

    public class BackendNestedImpl<N> extends IngressBackendFluentImpl<BackendNested<N>> implements BackendNested<N>{

        private final IngressBackendBuilder builder;
    
             BackendNestedImpl (){
        this.builder = new IngressBackendBuilder(this);
        }
             BackendNestedImpl ( IngressBackend item){
        this.builder = new IngressBackendBuilder(this, item);
        }
    
            public N and(){
            return (N) HTTPIngressPathFluentImpl.this.withBackend(builder.build());
        }
            public N endBackend(){
            return and();
        }
    
}


}
