package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class HTTPIngressRuleValueFluentImpl<A extends HTTPIngressRuleValueFluent<A>> extends BaseFluent<A> implements HTTPIngressRuleValueFluent<A>{

     List<VisitableBuilder<HTTPIngressPath, ?>> paths = new ArrayList();
public HTTPIngressRuleValueFluentImpl(){
    
}
public HTTPIngressRuleValueFluentImpl( HTTPIngressRuleValue instance ){
    this.withPaths(instance.getPaths()); 
}

    public A addToPaths( HTTPIngressPath ...items){
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.add(builder);this.paths.add(builder);} return (A)this;
    }
    public A removeFromPaths( HTTPIngressPath ...items){
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.remove(builder);this.paths.remove(builder);} return (A)this;
    }
    public List<HTTPIngressPath> getPaths(){
    return build(paths);
    }
    public A withPaths( List<HTTPIngressPath> paths){
    this.paths.clear();if (paths != null) {for (HTTPIngressPath item : paths){this.addToPaths(item);}} return (A) this;
    }
    public A withPaths( HTTPIngressPath ...paths){
    this.paths.clear(); if (paths != null) {for (HTTPIngressPath item :paths){ this.addToPaths(item);}} return (A) this;
    }
    public PathsNested<A> addNewPath(){
    return new PathsNestedImpl();
    }
    public PathsNested<A> addNewPathLike( HTTPIngressPath item){
    return new PathsNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HTTPIngressRuleValueFluentImpl that = (HTTPIngressRuleValueFluentImpl) o;
if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
return true;

    }

    public class PathsNestedImpl<N> extends HTTPIngressPathFluentImpl<PathsNested<N>> implements PathsNested<N>{

        private final HTTPIngressPathBuilder builder;
    
             PathsNestedImpl (){
        this.builder = new HTTPIngressPathBuilder(this);
        }
             PathsNestedImpl ( HTTPIngressPath item){
        this.builder = new HTTPIngressPathBuilder(this, item);
        }
    
            public N and(){
            return (N) HTTPIngressRuleValueFluentImpl.this.addToPaths(builder.build());
        }
            public N endPath(){
            return and();
        }
    
}


}
