package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class HorizontalPodAutoscalerSpecBuilder extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder> implements VisitableBuilder<HorizontalPodAutoscalerSpec,HorizontalPodAutoscalerSpecBuilder>{

     HorizontalPodAutoscalerSpecFluent<?> fluent;
public HorizontalPodAutoscalerSpecBuilder(){
    this(new HorizontalPodAutoscalerSpec());
}
public HorizontalPodAutoscalerSpecBuilder( HorizontalPodAutoscalerSpecFluent<?> fluent ){
    this(fluent, new HorizontalPodAutoscalerSpec());
}
public HorizontalPodAutoscalerSpecBuilder( HorizontalPodAutoscalerSpecFluent<?> fluent , HorizontalPodAutoscalerSpec instance ){
    this.fluent = fluent; fluent.withCpuUtilization(instance.getCpuUtilization()); fluent.withMaxReplicas(instance.getMaxReplicas()); fluent.withMinReplicas(instance.getMinReplicas()); fluent.withScaleRef(instance.getScaleRef()); 
}
public HorizontalPodAutoscalerSpecBuilder( HorizontalPodAutoscalerSpec instance ){
    this.fluent = this; this.withCpuUtilization(instance.getCpuUtilization()); this.withMaxReplicas(instance.getMaxReplicas()); this.withMinReplicas(instance.getMinReplicas()); this.withScaleRef(instance.getScaleRef()); 
}

public HorizontalPodAutoscalerSpec build(){
    HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(fluent.getCpuUtilization(),fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.getScaleRef());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
