package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>> extends BaseFluent<A> implements HorizontalPodAutoscalerSpecFluent<A>{

     VisitableBuilder<CPUTargetUtilization, ?> cpuUtilization;     Integer maxReplicas;     Integer minReplicas;     VisitableBuilder<SubresourceReference, ?> scaleRef;
public HorizontalPodAutoscalerSpecFluentImpl(){
    
}
public HorizontalPodAutoscalerSpecFluentImpl( HorizontalPodAutoscalerSpec instance ){
    this.withCpuUtilization(instance.getCpuUtilization()); this.withMaxReplicas(instance.getMaxReplicas()); this.withMinReplicas(instance.getMinReplicas()); this.withScaleRef(instance.getScaleRef()); 
}

    public CPUTargetUtilization getCpuUtilization(){
    return this.cpuUtilization!=null?this.cpuUtilization.build():null;
    }
    public A withCpuUtilization( CPUTargetUtilization cpuUtilization){
    if (cpuUtilization!=null){ this.cpuUtilization= new CPUTargetUtilizationBuilder(cpuUtilization); _visitables.add(this.cpuUtilization);} return (A) this;
    }
    public CpuUtilizationNested<A> withNewCpuUtilization(){
    return new CpuUtilizationNestedImpl();
    }
    public CpuUtilizationNested<A> withNewCpuUtilizationLike( CPUTargetUtilization item){
    return new CpuUtilizationNestedImpl(item);
    }
    public CpuUtilizationNested<A> editCpuUtilization(){
    return withNewCpuUtilizationLike(getCpuUtilization());
    }
    public A withNewCpuUtilization( Integer targetPercentage){
    return withCpuUtilization(new CPUTargetUtilization(targetPercentage));
    }
    public Integer getMaxReplicas(){
    return this.maxReplicas;
    }
    public A withMaxReplicas( Integer maxReplicas){
    this.maxReplicas=maxReplicas; return (A) this;
    }
    public Integer getMinReplicas(){
    return this.minReplicas;
    }
    public A withMinReplicas( Integer minReplicas){
    this.minReplicas=minReplicas; return (A) this;
    }
    public SubresourceReference getScaleRef(){
    return this.scaleRef!=null?this.scaleRef.build():null;
    }
    public A withScaleRef( SubresourceReference scaleRef){
    if (scaleRef!=null){ this.scaleRef= new SubresourceReferenceBuilder(scaleRef); _visitables.add(this.scaleRef);} return (A) this;
    }
    public ScaleRefNested<A> withNewScaleRef(){
    return new ScaleRefNestedImpl();
    }
    public ScaleRefNested<A> withNewScaleRefLike( SubresourceReference item){
    return new ScaleRefNestedImpl(item);
    }
    public ScaleRefNested<A> editScaleRef(){
    return withNewScaleRefLike(getScaleRef());
    }
    public A withNewScaleRef( String apiVersion,  String kind,  String name,  String subresource){
    return withScaleRef(new SubresourceReference(apiVersion, kind, name, subresource));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
if (cpuUtilization != null ? !cpuUtilization.equals(that.cpuUtilization) :that.cpuUtilization != null) return false;
if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
if (scaleRef != null ? !scaleRef.equals(that.scaleRef) :that.scaleRef != null) return false;
return true;

    }

    public class CpuUtilizationNestedImpl<N> extends CPUTargetUtilizationFluentImpl<CpuUtilizationNested<N>> implements CpuUtilizationNested<N>{

        private final CPUTargetUtilizationBuilder builder;
    
             CpuUtilizationNestedImpl (){
        this.builder = new CPUTargetUtilizationBuilder(this);
        }
             CpuUtilizationNestedImpl ( CPUTargetUtilization item){
        this.builder = new CPUTargetUtilizationBuilder(this, item);
        }
    
            public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withCpuUtilization(builder.build());
        }
            public N endCpuUtilization(){
            return and();
        }
    
}
    public class ScaleRefNestedImpl<N> extends SubresourceReferenceFluentImpl<ScaleRefNested<N>> implements ScaleRefNested<N>{

        private final SubresourceReferenceBuilder builder;
    
             ScaleRefNestedImpl (){
        this.builder = new SubresourceReferenceBuilder(this);
        }
             ScaleRefNestedImpl ( SubresourceReference item){
        this.builder = new SubresourceReferenceBuilder(this, item);
        }
    
            public N endScaleRef(){
            return and();
        }
            public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleRef(builder.build());
        }
    
}


}
