package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class IngressBackendBuilder extends IngressBackendFluentImpl<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,IngressBackendBuilder>{

     IngressBackendFluent<?> fluent;
public IngressBackendBuilder(){
    this(new IngressBackend());
}
public IngressBackendBuilder( IngressBackendFluent<?> fluent ){
    this(fluent, new IngressBackend());
}
public IngressBackendBuilder( IngressBackendFluent<?> fluent , IngressBackend instance ){
    this.fluent = fluent; fluent.withServiceName(instance.getServiceName()); fluent.withServicePort(instance.getServicePort()); 
}
public IngressBackendBuilder( IngressBackend instance ){
    this.fluent = this; this.withServiceName(instance.getServiceName()); this.withServicePort(instance.getServicePort()); 
}

public IngressBackend build(){
    IngressBackend buildable = new IngressBackend(fluent.getServiceName(),fluent.getServicePort());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
IngressBackendBuilder that = (IngressBackendBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
