package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>> extends BaseFluent<A> implements IngressBackendFluent<A>{

     String serviceName;     VisitableBuilder<IntOrString, ?> servicePort;
public IngressBackendFluentImpl(){
    
}
public IngressBackendFluentImpl( IngressBackend instance ){
    this.withServiceName(instance.getServiceName()); this.withServicePort(instance.getServicePort()); 
}

    public String getServiceName(){
    return this.serviceName;
    }
    public A withServiceName( String serviceName){
    this.serviceName=serviceName; return (A) this;
    }
    public IntOrString getServicePort(){
    return this.servicePort!=null?this.servicePort.build():null;
    }
    public A withServicePort( IntOrString servicePort){
    if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.add(this.servicePort);} return (A) this;
    }
    public ServicePortNested<A> withNewServicePort(){
    return new ServicePortNestedImpl();
    }
    public ServicePortNested<A> withNewServicePortLike( IntOrString item){
    return new ServicePortNestedImpl(item);
    }
    public ServicePortNested<A> editServicePort(){
    return withNewServicePortLike(getServicePort());
    }
    public A withNewServicePort( String strVal){
    return withServicePort(new IntOrString(strVal));
    }
    public A withNewServicePort( Integer intVal){
    return withServicePort(new IntOrString(intVal));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
return true;

    }

    public class ServicePortNestedImpl<N> extends IntOrStringFluentImpl<ServicePortNested<N>> implements ServicePortNested<N>{

        private final IntOrStringBuilder builder;
    
             ServicePortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             ServicePortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N and(){
            return (N) IngressBackendFluentImpl.this.withServicePort(builder.build());
        }
            public N endServicePort(){
            return and();
        }
    
}


}
