package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class IngressTLSFluentImpl<A extends IngressTLSFluent<A>> extends BaseFluent<A> implements IngressTLSFluent<A>{

     List<String> hosts = new ArrayList();     String secretName;
public IngressTLSFluentImpl(){
    
}
public IngressTLSFluentImpl( IngressTLS instance ){
    this.withHosts(instance.getHosts()); this.withSecretName(instance.getSecretName()); 
}

    public A addToHosts( String ...items){
    for (String item : items) {this.hosts.add(item);} return (A)this;
    }
    public A removeFromHosts( String ...items){
    for (String item : items) {this.hosts.remove(item);} return (A)this;
    }
    public List<String> getHosts(){
    return this.hosts;
    }
    public A withHosts( List<String> hosts){
    this.hosts.clear();if (hosts != null) {for (String item : hosts){this.addToHosts(item);}} return (A) this;
    }
    public A withHosts( String ...hosts){
    this.hosts.clear(); if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }
    public String getSecretName(){
    return this.secretName;
    }
    public A withSecretName( String secretName){
    this.secretName=secretName; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressTLSFluentImpl that = (IngressTLSFluentImpl) o;
if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
return true;

    }



}
