package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class JobStatusBuilder extends JobStatusFluentImpl<JobStatusBuilder> implements VisitableBuilder<JobStatus,JobStatusBuilder>{

     JobStatusFluent<?> fluent;
public JobStatusBuilder(){
    this(new JobStatus());
}
public JobStatusBuilder( JobStatusFluent<?> fluent ){
    this(fluent, new JobStatus());
}
public JobStatusBuilder( JobStatusFluent<?> fluent , JobStatus instance ){
    this.fluent = fluent; fluent.withActive(instance.getActive()); fluent.withCompletionTime(instance.getCompletionTime()); fluent.withConditions(instance.getConditions()); fluent.withFailed(instance.getFailed()); fluent.withStartTime(instance.getStartTime()); fluent.withSucceeded(instance.getSucceeded()); 
}
public JobStatusBuilder( JobStatus instance ){
    this.fluent = this; this.withActive(instance.getActive()); this.withCompletionTime(instance.getCompletionTime()); this.withConditions(instance.getConditions()); this.withFailed(instance.getFailed()); this.withStartTime(instance.getStartTime()); this.withSucceeded(instance.getSucceeded()); 
}

public JobStatus build(){
    JobStatus buildable = new JobStatus(fluent.getActive(),fluent.getCompletionTime(),fluent.getConditions(),fluent.getFailed(),fluent.getStartTime(),fluent.getSucceeded());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
JobStatusBuilder that = (JobStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
