package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class LabelSelectorRequirementBuilder extends LabelSelectorRequirementFluentImpl<LabelSelectorRequirementBuilder> implements VisitableBuilder<LabelSelectorRequirement,LabelSelectorRequirementBuilder>{

     LabelSelectorRequirementFluent<?> fluent;
public LabelSelectorRequirementBuilder(){
    this(new LabelSelectorRequirement());
}
public LabelSelectorRequirementBuilder( LabelSelectorRequirementFluent<?> fluent ){
    this(fluent, new LabelSelectorRequirement());
}
public LabelSelectorRequirementBuilder( LabelSelectorRequirementFluent<?> fluent , LabelSelectorRequirement instance ){
    this.fluent = fluent; fluent.withKey(instance.getKey()); fluent.withOperator(instance.getOperator()); fluent.withValues(instance.getValues()); 
}
public LabelSelectorRequirementBuilder( LabelSelectorRequirement instance ){
    this.fluent = this; this.withKey(instance.getKey()); this.withOperator(instance.getOperator()); this.withValues(instance.getValues()); 
}

public LabelSelectorRequirement build(){
    LabelSelectorRequirement buildable = new LabelSelectorRequirement(fluent.getKey(),fluent.getOperator(),fluent.getValues());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
LabelSelectorRequirementBuilder that = (LabelSelectorRequirementBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
