package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ReplicaSetStatusBuilder extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder> implements VisitableBuilder<ReplicaSetStatus,ReplicaSetStatusBuilder>{

     ReplicaSetStatusFluent<?> fluent;
public ReplicaSetStatusBuilder(){
    this(new ReplicaSetStatus());
}
public ReplicaSetStatusBuilder( ReplicaSetStatusFluent<?> fluent ){
    this(fluent, new ReplicaSetStatus());
}
public ReplicaSetStatusBuilder( ReplicaSetStatusFluent<?> fluent , ReplicaSetStatus instance ){
    this.fluent = fluent; fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); fluent.withObservedGeneration(instance.getObservedGeneration()); fluent.withReplicas(instance.getReplicas()); 
}
public ReplicaSetStatusBuilder( ReplicaSetStatus instance ){
    this.fluent = this; this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); this.withObservedGeneration(instance.getObservedGeneration()); this.withReplicas(instance.getReplicas()); 
}

public ReplicaSetStatus build(){
    ReplicaSetStatus buildable = new ReplicaSetStatus(fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReplicas());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ReplicaSetStatusBuilder that = (ReplicaSetStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
