package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RollingUpdateDeploymentBuilder extends RollingUpdateDeploymentFluentImpl<RollingUpdateDeploymentBuilder> implements VisitableBuilder<RollingUpdateDeployment,RollingUpdateDeploymentBuilder>{

     RollingUpdateDeploymentFluent<?> fluent;
public RollingUpdateDeploymentBuilder(){
    this(new RollingUpdateDeployment());
}
public RollingUpdateDeploymentBuilder( RollingUpdateDeploymentFluent<?> fluent ){
    this(fluent, new RollingUpdateDeployment());
}
public RollingUpdateDeploymentBuilder( RollingUpdateDeploymentFluent<?> fluent , RollingUpdateDeployment instance ){
    this.fluent = fluent; fluent.withMaxSurge(instance.getMaxSurge()); fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
}
public RollingUpdateDeploymentBuilder( RollingUpdateDeployment instance ){
    this.fluent = this; this.withMaxSurge(instance.getMaxSurge()); this.withMaxUnavailable(instance.getMaxUnavailable()); 
}

public RollingUpdateDeployment build(){
    RollingUpdateDeployment buildable = new RollingUpdateDeployment(fluent.getMaxSurge(),fluent.getMaxUnavailable());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RollingUpdateDeploymentBuilder that = (RollingUpdateDeploymentBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
