package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class RollingUpdateDeploymentFluentImpl<A extends RollingUpdateDeploymentFluent<A>> extends BaseFluent<A> implements RollingUpdateDeploymentFluent<A>{

     VisitableBuilder<IntOrString, ?> maxSurge;     VisitableBuilder<IntOrString, ?> maxUnavailable;
public RollingUpdateDeploymentFluentImpl(){
    
}
public RollingUpdateDeploymentFluentImpl( RollingUpdateDeployment instance ){
    this.withMaxSurge(instance.getMaxSurge()); this.withMaxUnavailable(instance.getMaxUnavailable()); 
}

    public IntOrString getMaxSurge(){
    return this.maxSurge!=null?this.maxSurge.build():null;
    }
    public A withMaxSurge( IntOrString maxSurge){
    if (maxSurge!=null){ this.maxSurge= new IntOrStringBuilder(maxSurge); _visitables.add(this.maxSurge);} return (A) this;
    }
    public MaxSurgeNested<A> withNewMaxSurge(){
    return new MaxSurgeNestedImpl();
    }
    public MaxSurgeNested<A> withNewMaxSurgeLike( IntOrString item){
    return new MaxSurgeNestedImpl(item);
    }
    public MaxSurgeNested<A> editMaxSurge(){
    return withNewMaxSurgeLike(getMaxSurge());
    }
    public A withNewMaxSurge( String strVal){
    return withMaxSurge(new IntOrString(strVal));
    }
    public A withNewMaxSurge( Integer intVal){
    return withMaxSurge(new IntOrString(intVal));
    }
    public IntOrString getMaxUnavailable(){
    return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }
    public A withMaxUnavailable( IntOrString maxUnavailable){
    if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.add(this.maxUnavailable);} return (A) this;
    }
    public MaxUnavailableNested<A> withNewMaxUnavailable(){
    return new MaxUnavailableNestedImpl();
    }
    public MaxUnavailableNested<A> withNewMaxUnavailableLike( IntOrString item){
    return new MaxUnavailableNestedImpl(item);
    }
    public MaxUnavailableNested<A> editMaxUnavailable(){
    return withNewMaxUnavailableLike(getMaxUnavailable());
    }
    public A withNewMaxUnavailable( String strVal){
    return withMaxUnavailable(new IntOrString(strVal));
    }
    public A withNewMaxUnavailable( Integer intVal){
    return withMaxUnavailable(new IntOrString(intVal));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RollingUpdateDeploymentFluentImpl that = (RollingUpdateDeploymentFluentImpl) o;
if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
return true;

    }

    public class MaxSurgeNestedImpl<N> extends IntOrStringFluentImpl<MaxSurgeNested<N>> implements MaxSurgeNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxSurgeNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxSurgeNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N and(){
            return (N) RollingUpdateDeploymentFluentImpl.this.withMaxSurge(builder.build());
        }
            public N endMaxSurge(){
            return and();
        }
    
}
    public class MaxUnavailableNestedImpl<N> extends IntOrStringFluentImpl<MaxUnavailableNested<N>> implements MaxUnavailableNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxUnavailableNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxUnavailableNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endMaxUnavailable(){
            return and();
        }
            public N and(){
            return (N) RollingUpdateDeploymentFluentImpl.this.withMaxUnavailable(builder.build());
        }
    
}


}
