package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildConfigFluentImpl<A extends BuildConfigFluent<A>> extends BaseFluent<A> implements BuildConfigFluent<A>{

     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<BuildConfigSpec, ?> spec;     VisitableBuilder<BuildConfigStatus, ?> status;
public BuildConfigFluentImpl(){
    
}
public BuildConfigFluentImpl( BuildConfig instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); this.withStatus(instance.getStatus()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public BuildConfigSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public A withSpec( BuildConfigSpec spec){
    if (spec!=null){ this.spec= new BuildConfigSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }
    public SpecNested<A> withNewSpec(){
    return new SpecNestedImpl();
    }
    public SpecNested<A> withNewSpecLike( BuildConfigSpec item){
    return new SpecNestedImpl(item);
    }
    public SpecNested<A> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public BuildConfigStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public A withStatus( BuildConfigStatus status){
    if (status!=null){ this.status= new BuildConfigStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }
    public StatusNested<A> withNewStatus(){
    return new StatusNestedImpl();
    }
    public StatusNested<A> withNewStatusLike( BuildConfigStatus item){
    return new StatusNestedImpl(item);
    }
    public StatusNested<A> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public A withNewStatus( Integer lastVersion){
    return withStatus(new BuildConfigStatus(lastVersion));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildConfigFluentImpl that = (BuildConfigFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) BuildConfigFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNestedImpl<N> extends BuildConfigSpecFluentImpl<SpecNested<N>> implements SpecNested<N>{

        private final BuildConfigSpecBuilder builder;
    
             SpecNestedImpl (){
        this.builder = new BuildConfigSpecBuilder(this);
        }
             SpecNestedImpl ( BuildConfigSpec item){
        this.builder = new BuildConfigSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) BuildConfigFluentImpl.this.withSpec(builder.build());
        }
    
}
    public class StatusNestedImpl<N> extends BuildConfigStatusFluentImpl<StatusNested<N>> implements StatusNested<N>{

        private final BuildConfigStatusBuilder builder;
    
             StatusNestedImpl (){
        this.builder = new BuildConfigStatusBuilder(this);
        }
             StatusNestedImpl ( BuildConfigStatus item){
        this.builder = new BuildConfigStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigFluentImpl.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
