package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildConfigSpecFluentImpl<A extends BuildConfigSpecFluent<A>> extends BaseFluent<A> implements BuildConfigSpecFluent<A>{

     Long completionDeadlineSeconds;     VisitableBuilder<BuildOutput, ?> output;     VisitableBuilder<BuildPostCommitSpec, ?> postCommit;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<SourceRevision, ?> revision;     String runPolicy;     String serviceAccount;     VisitableBuilder<BuildSource, ?> source;     VisitableBuilder<BuildStrategy, ?> strategy;     List<VisitableBuilder<BuildTriggerPolicy, ?>> triggers = new ArrayList();
public BuildConfigSpecFluentImpl(){
    
}
public BuildConfigSpecFluentImpl( BuildConfigSpec instance ){
    this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); this.withOutput(instance.getOutput()); this.withPostCommit(instance.getPostCommit()); this.withResources(instance.getResources()); this.withRevision(instance.getRevision()); this.withRunPolicy(instance.getRunPolicy()); this.withServiceAccount(instance.getServiceAccount()); this.withSource(instance.getSource()); this.withStrategy(instance.getStrategy()); this.withTriggers(instance.getTriggers()); 
}

    public Long getCompletionDeadlineSeconds(){
    return this.completionDeadlineSeconds;
    }
    public A withCompletionDeadlineSeconds( Long completionDeadlineSeconds){
    this.completionDeadlineSeconds=completionDeadlineSeconds; return (A) this;
    }
    public BuildOutput getOutput(){
    return this.output!=null?this.output.build():null;
    }
    public A withOutput( BuildOutput output){
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.add(this.output);} return (A) this;
    }
    public OutputNested<A> withNewOutput(){
    return new OutputNestedImpl();
    }
    public OutputNested<A> withNewOutputLike( BuildOutput item){
    return new OutputNestedImpl(item);
    }
    public OutputNested<A> editOutput(){
    return withNewOutputLike(getOutput());
    }
    public BuildPostCommitSpec getPostCommit(){
    return this.postCommit!=null?this.postCommit.build():null;
    }
    public A withPostCommit( BuildPostCommitSpec postCommit){
    if (postCommit!=null){ this.postCommit= new BuildPostCommitSpecBuilder(postCommit); _visitables.add(this.postCommit);} return (A) this;
    }
    public PostCommitNested<A> withNewPostCommit(){
    return new PostCommitNestedImpl();
    }
    public PostCommitNested<A> withNewPostCommitLike( BuildPostCommitSpec item){
    return new PostCommitNestedImpl(item);
    }
    public PostCommitNested<A> editPostCommit(){
    return withNewPostCommitLike(getPostCommit());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public A withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (A) this;
    }
    public ResourcesNested<A> withNewResources(){
    return new ResourcesNestedImpl();
    }
    public ResourcesNested<A> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNestedImpl(item);
    }
    public ResourcesNested<A> editResources(){
    return withNewResourcesLike(getResources());
    }
    public SourceRevision getRevision(){
    return this.revision!=null?this.revision.build():null;
    }
    public A withRevision( SourceRevision revision){
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (A) this;
    }
    public RevisionNested<A> withNewRevision(){
    return new RevisionNestedImpl();
    }
    public RevisionNested<A> withNewRevisionLike( SourceRevision item){
    return new RevisionNestedImpl(item);
    }
    public RevisionNested<A> editRevision(){
    return withNewRevisionLike(getRevision());
    }
    public String getRunPolicy(){
    return this.runPolicy;
    }
    public A withRunPolicy( String runPolicy){
    this.runPolicy=runPolicy; return (A) this;
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public A withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (A) this;
    }
    public BuildSource getSource(){
    return this.source!=null?this.source.build():null;
    }
    public A withSource( BuildSource source){
    if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.add(this.source);} return (A) this;
    }
    public SourceNested<A> withNewSource(){
    return new SourceNestedImpl();
    }
    public SourceNested<A> withNewSourceLike( BuildSource item){
    return new SourceNestedImpl(item);
    }
    public SourceNested<A> editSource(){
    return withNewSourceLike(getSource());
    }
    public BuildStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public A withStrategy( BuildStrategy strategy){
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }
    public StrategyNested<A> withNewStrategy(){
    return new StrategyNestedImpl();
    }
    public StrategyNested<A> withNewStrategyLike( BuildStrategy item){
    return new StrategyNestedImpl(item);
    }
    public StrategyNested<A> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public A addToTriggers( BuildTriggerPolicy ...items){
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (A)this;
    }
    public A removeFromTriggers( BuildTriggerPolicy ...items){
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.remove(builder);this.triggers.remove(builder);} return (A)this;
    }
    public List<BuildTriggerPolicy> getTriggers(){
    return build(triggers);
    }
    public A withTriggers( List<BuildTriggerPolicy> triggers){
    this.triggers.clear();if (triggers != null) {for (BuildTriggerPolicy item : triggers){this.addToTriggers(item);}} return (A) this;
    }
    public A withTriggers( BuildTriggerPolicy ...triggers){
    this.triggers.clear(); if (triggers != null) {for (BuildTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
    }
    public TriggersNested<A> addNewTrigger(){
    return new TriggersNestedImpl();
    }
    public TriggersNested<A> addNewTriggerLike( BuildTriggerPolicy item){
    return new TriggersNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl) o;
if (completionDeadlineSeconds != null ? !completionDeadlineSeconds.equals(that.completionDeadlineSeconds) :that.completionDeadlineSeconds != null) return false;
if (output != null ? !output.equals(that.output) :that.output != null) return false;
if (postCommit != null ? !postCommit.equals(that.postCommit) :that.postCommit != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
if (runPolicy != null ? !runPolicy.equals(that.runPolicy) :that.runPolicy != null) return false;
if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
if (source != null ? !source.equals(that.source) :that.source != null) return false;
if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
return true;

    }

    public class OutputNestedImpl<N> extends BuildOutputFluentImpl<OutputNested<N>> implements OutputNested<N>{

        private final BuildOutputBuilder builder;
    
             OutputNestedImpl (){
        this.builder = new BuildOutputBuilder(this);
        }
             OutputNestedImpl ( BuildOutput item){
        this.builder = new BuildOutputBuilder(this, item);
        }
    
            public N endOutput(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withOutput(builder.build());
        }
    
}
    public class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<PostCommitNested<N>> implements PostCommitNested<N>{

        private final BuildPostCommitSpecBuilder builder;
    
             PostCommitNestedImpl (){
        this.builder = new BuildPostCommitSpecBuilder(this);
        }
             PostCommitNestedImpl ( BuildPostCommitSpec item){
        this.builder = new BuildPostCommitSpecBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withPostCommit(builder.build());
        }
            public N endPostCommit(){
            return and();
        }
    
}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ResourcesNested<N>> implements ResourcesNested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNestedImpl (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNestedImpl ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<RevisionNested<N>> implements RevisionNested<N>{

        private final SourceRevisionBuilder builder;
    
             RevisionNestedImpl (){
        this.builder = new SourceRevisionBuilder(this);
        }
             RevisionNestedImpl ( SourceRevision item){
        this.builder = new SourceRevisionBuilder(this, item);
        }
    
            public N endRevision(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withRevision(builder.build());
        }
    
}
    public class SourceNestedImpl<N> extends BuildSourceFluentImpl<SourceNested<N>> implements SourceNested<N>{

        private final BuildSourceBuilder builder;
    
             SourceNestedImpl (){
        this.builder = new BuildSourceBuilder(this);
        }
             SourceNestedImpl ( BuildSource item){
        this.builder = new BuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withSource(builder.build());
        }
            public N endSource(){
            return and();
        }
    
}
    public class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<StrategyNested<N>> implements StrategyNested<N>{

        private final BuildStrategyBuilder builder;
    
             StrategyNestedImpl (){
        this.builder = new BuildStrategyBuilder(this);
        }
             StrategyNestedImpl ( BuildStrategy item){
        this.builder = new BuildStrategyBuilder(this, item);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withStrategy(builder.build());
        }
    
}
    public class TriggersNestedImpl<N> extends BuildTriggerPolicyFluentImpl<TriggersNested<N>> implements TriggersNested<N>{

        private final BuildTriggerPolicyBuilder builder;
    
             TriggersNestedImpl (){
        this.builder = new BuildTriggerPolicyBuilder(this);
        }
             TriggersNestedImpl ( BuildTriggerPolicy item){
        this.builder = new BuildTriggerPolicyBuilder(this, item);
        }
    
            public N endTrigger(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.addToTriggers(builder.build());
        }
    
}


}
