package io.fabric8.openshift.api.model;

import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildRequestFluentImpl<A extends BuildRequestFluent<A>> extends BaseFluent<A> implements BuildRequestFluent<A>{

     String apiVersion;     VisitableBuilder<BinaryBuildSource, ?> binary;     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     VisitableBuilder<ObjectReference, ?> from;     String kind;     Integer lastVersion;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<SourceRevision, ?> revision;     VisitableBuilder<ObjectReference, ?> triggeredByImage;
public BuildRequestFluentImpl(){
    
}
public BuildRequestFluentImpl( BuildRequest instance ){
    this.withApiVersion(instance.getApiVersion()); this.withBinary(instance.getBinary()); this.withEnv(instance.getEnv()); this.withFrom(instance.getFrom()); this.withKind(instance.getKind()); this.withLastVersion(instance.getLastVersion()); this.withMetadata(instance.getMetadata()); this.withRevision(instance.getRevision()); this.withTriggeredByImage(instance.getTriggeredByImage()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public BinaryBuildSource getBinary(){
    return this.binary!=null?this.binary.build():null;
    }
    public A withBinary( BinaryBuildSource binary){
    if (binary!=null){ this.binary= new BinaryBuildSourceBuilder(binary); _visitables.add(this.binary);} return (A) this;
    }
    public BinaryNested<A> withNewBinary(){
    return new BinaryNestedImpl();
    }
    public BinaryNested<A> withNewBinaryLike( BinaryBuildSource item){
    return new BinaryNestedImpl(item);
    }
    public BinaryNested<A> editBinary(){
    return withNewBinaryLike(getBinary());
    }
    public A withNewBinary( String asFile){
    return withBinary(new BinaryBuildSource(asFile));
    }
    public A addToEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }
    public A removeFromEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public A withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }
    public A withEnv( EnvVar ...env){
    this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }
    public EnvNested<A> addNewEnv(){
    return new EnvNestedImpl();
    }
    public EnvNested<A> addNewEnvLike( EnvVar item){
    return new EnvNestedImpl(item);
    }
    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public A withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }
    public FromNested<A> withNewFrom(){
    return new FromNestedImpl();
    }
    public FromNested<A> withNewFromLike( ObjectReference item){
    return new FromNestedImpl(item);
    }
    public FromNested<A> editFrom(){
    return withNewFromLike(getFrom());
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public Integer getLastVersion(){
    return this.lastVersion;
    }
    public A withLastVersion( Integer lastVersion){
    this.lastVersion=lastVersion; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public SourceRevision getRevision(){
    return this.revision!=null?this.revision.build():null;
    }
    public A withRevision( SourceRevision revision){
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (A) this;
    }
    public RevisionNested<A> withNewRevision(){
    return new RevisionNestedImpl();
    }
    public RevisionNested<A> withNewRevisionLike( SourceRevision item){
    return new RevisionNestedImpl(item);
    }
    public RevisionNested<A> editRevision(){
    return withNewRevisionLike(getRevision());
    }
    public ObjectReference getTriggeredByImage(){
    return this.triggeredByImage!=null?this.triggeredByImage.build():null;
    }
    public A withTriggeredByImage( ObjectReference triggeredByImage){
    if (triggeredByImage!=null){ this.triggeredByImage= new ObjectReferenceBuilder(triggeredByImage); _visitables.add(this.triggeredByImage);} return (A) this;
    }
    public TriggeredByImageNested<A> withNewTriggeredByImage(){
    return new TriggeredByImageNestedImpl();
    }
    public TriggeredByImageNested<A> withNewTriggeredByImageLike( ObjectReference item){
    return new TriggeredByImageNestedImpl(item);
    }
    public TriggeredByImageNested<A> editTriggeredByImage(){
    return withNewTriggeredByImageLike(getTriggeredByImage());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildRequestFluentImpl that = (BuildRequestFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (binary != null ? !binary.equals(that.binary) :that.binary != null) return false;
if (env != null ? !env.equals(that.env) :that.env != null) return false;
if (from != null ? !from.equals(that.from) :that.from != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastVersion != null ? !lastVersion.equals(that.lastVersion) :that.lastVersion != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
if (triggeredByImage != null ? !triggeredByImage.equals(that.triggeredByImage) :that.triggeredByImage != null) return false;
return true;

    }

    public class BinaryNestedImpl<N> extends BinaryBuildSourceFluentImpl<BinaryNested<N>> implements BinaryNested<N>{

        private final BinaryBuildSourceBuilder builder;
    
             BinaryNestedImpl (){
        this.builder = new BinaryBuildSourceBuilder(this);
        }
             BinaryNestedImpl ( BinaryBuildSource item){
        this.builder = new BinaryBuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildRequestFluentImpl.this.withBinary(builder.build());
        }
            public N endBinary(){
            return and();
        }
    
}
    public class EnvNestedImpl<N> extends EnvVarFluentImpl<EnvNested<N>> implements EnvNested<N>{

        private final EnvVarBuilder builder;
    
             EnvNestedImpl (){
        this.builder = new EnvVarBuilder(this);
        }
             EnvNestedImpl ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
    
            public N endEnv(){
            return and();
        }
            public N and(){
            return (N) BuildRequestFluentImpl.this.addToEnv(builder.build());
        }
    
}
    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<FromNested<N>> implements FromNested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             FromNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) BuildRequestFluentImpl.this.withFrom(builder.build());
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) BuildRequestFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<RevisionNested<N>> implements RevisionNested<N>{

        private final SourceRevisionBuilder builder;
    
             RevisionNestedImpl (){
        this.builder = new SourceRevisionBuilder(this);
        }
             RevisionNestedImpl ( SourceRevision item){
        this.builder = new SourceRevisionBuilder(this, item);
        }
    
            public N endRevision(){
            return and();
        }
            public N and(){
            return (N) BuildRequestFluentImpl.this.withRevision(builder.build());
        }
    
}
    public class TriggeredByImageNestedImpl<N> extends ObjectReferenceFluentImpl<TriggeredByImageNested<N>> implements TriggeredByImageNested<N>{

        private final ObjectReferenceBuilder builder;
    
             TriggeredByImageNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             TriggeredByImageNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildRequestFluentImpl.this.withTriggeredByImage(builder.build());
        }
            public N endTriggeredByImage(){
            return and();
        }
    
}


}
