package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildSourceFluent<A extends BuildSourceFluent<A>> extends Fluent<A>{


    public BinaryBuildSource getBinary();    public A withBinary( BinaryBuildSource binary);    public BinaryNested<A> withNewBinary();    public BinaryNested<A> withNewBinaryLike( BinaryBuildSource item);    public BinaryNested<A> editBinary();    public A withNewBinary( String asFile);    public String getContextDir();    public A withContextDir( String contextDir);    public String getDockerfile();    public A withDockerfile( String dockerfile);    public GitBuildSource getGit();    public A withGit( GitBuildSource git);    public GitNested<A> withNewGit();    public GitNested<A> withNewGitLike( GitBuildSource item);    public GitNested<A> editGit();    public A withNewGit( String httpProxy,  String httpsProxy,  String ref,  String uri);    public A addToImages( ImageSource ...items);    public A removeFromImages( ImageSource ...items);    public List<ImageSource> getImages();    public A withImages( List<ImageSource> images);    public A withImages( ImageSource ...images);    public ImagesNested<A> addNewImage();    public ImagesNested<A> addNewImageLike( ImageSource item);    public A addToSecrets( SecretBuildSource ...items);    public A removeFromSecrets( SecretBuildSource ...items);    public List<SecretBuildSource> getSecrets();    public A withSecrets( List<SecretBuildSource> secrets);    public A withSecrets( SecretBuildSource ...secrets);    public SecretsNested<A> addNewSecret();    public SecretsNested<A> addNewSecretLike( SecretBuildSource item);    public LocalObjectReference getSourceSecret();    public A withSourceSecret( LocalObjectReference sourceSecret);    public SourceSecretNested<A> withNewSourceSecret();    public SourceSecretNested<A> withNewSourceSecretLike( LocalObjectReference item);    public SourceSecretNested<A> editSourceSecret();    public A withNewSourceSecret( String name);    public String getType();    public A withType( String type);
    public interface BinaryNested<N> extends Nested<N>,BinaryBuildSourceFluent<BinaryNested<N>>{
            public N and();            public N endBinary();        
}

    public interface GitNested<N> extends Nested<N>,GitBuildSourceFluent<GitNested<N>>{
            public N and();            public N endGit();        
}

    public interface ImagesNested<N> extends Nested<N>,ImageSourceFluent<ImagesNested<N>>{
            public N and();            public N endImage();        
}

    public interface SecretsNested<N> extends Nested<N>,SecretBuildSourceFluent<SecretsNested<N>>{
            public N and();            public N endSecret();        
}

    public interface SourceSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<SourceSecretNested<N>>{
            public N and();            public N endSourceSecret();        
}


}
