package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildSpecFluent<A extends BuildSpecFluent<A>> extends Fluent<A>{


    public Long getCompletionDeadlineSeconds();    public A withCompletionDeadlineSeconds( Long completionDeadlineSeconds);    public BuildOutput getOutput();    public A withOutput( BuildOutput output);    public OutputNested<A> withNewOutput();    public OutputNested<A> withNewOutputLike( BuildOutput item);    public OutputNested<A> editOutput();    public BuildPostCommitSpec getPostCommit();    public A withPostCommit( BuildPostCommitSpec postCommit);    public PostCommitNested<A> withNewPostCommit();    public PostCommitNested<A> withNewPostCommitLike( BuildPostCommitSpec item);    public PostCommitNested<A> editPostCommit();    public ResourceRequirements getResources();    public A withResources( ResourceRequirements resources);    public ResourcesNested<A> withNewResources();    public ResourcesNested<A> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<A> editResources();    public SourceRevision getRevision();    public A withRevision( SourceRevision revision);    public RevisionNested<A> withNewRevision();    public RevisionNested<A> withNewRevisionLike( SourceRevision item);    public RevisionNested<A> editRevision();    public String getServiceAccount();    public A withServiceAccount( String serviceAccount);    public BuildSource getSource();    public A withSource( BuildSource source);    public SourceNested<A> withNewSource();    public SourceNested<A> withNewSourceLike( BuildSource item);    public SourceNested<A> editSource();    public BuildStrategy getStrategy();    public A withStrategy( BuildStrategy strategy);    public StrategyNested<A> withNewStrategy();    public StrategyNested<A> withNewStrategyLike( BuildStrategy item);    public StrategyNested<A> editStrategy();
    public interface OutputNested<N> extends Nested<N>,BuildOutputFluent<OutputNested<N>>{
            public N endOutput();            public N and();        
}

    public interface PostCommitNested<N> extends Nested<N>,BuildPostCommitSpecFluent<PostCommitNested<N>>{
            public N and();            public N endPostCommit();        
}

    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<RevisionNested<N>>{
            public N endRevision();            public N and();        
}

    public interface SourceNested<N> extends Nested<N>,BuildSourceFluent<SourceNested<N>>{
            public N and();            public N endSource();        
}

    public interface StrategyNested<N> extends Nested<N>,BuildStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}


}
