package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class BuildTriggerPolicyFluentImpl<A extends BuildTriggerPolicyFluent<A>> extends BaseFluent<A> implements BuildTriggerPolicyFluent<A>{

     VisitableBuilder<WebHookTrigger, ?> generic;     VisitableBuilder<WebHookTrigger, ?> github;     VisitableBuilder<ImageChangeTrigger, ?> imageChange;     String type;
public BuildTriggerPolicyFluentImpl(){
    
}
public BuildTriggerPolicyFluentImpl( BuildTriggerPolicy instance ){
    this.withGeneric(instance.getGeneric()); this.withGithub(instance.getGithub()); this.withImageChange(instance.getImageChange()); this.withType(instance.getType()); 
}

    public WebHookTrigger getGeneric(){
    return this.generic!=null?this.generic.build():null;
    }
    public A withGeneric( WebHookTrigger generic){
    if (generic!=null){ this.generic= new WebHookTriggerBuilder(generic); _visitables.add(this.generic);} return (A) this;
    }
    public GenericNested<A> withNewGeneric(){
    return new GenericNestedImpl();
    }
    public GenericNested<A> withNewGenericLike( WebHookTrigger item){
    return new GenericNestedImpl(item);
    }
    public GenericNested<A> editGeneric(){
    return withNewGenericLike(getGeneric());
    }
    public A withNewGeneric( Boolean allowEnv,  String secret){
    return withGeneric(new WebHookTrigger(allowEnv, secret));
    }
    public WebHookTrigger getGithub(){
    return this.github!=null?this.github.build():null;
    }
    public A withGithub( WebHookTrigger github){
    if (github!=null){ this.github= new WebHookTriggerBuilder(github); _visitables.add(this.github);} return (A) this;
    }
    public GithubNested<A> withNewGithub(){
    return new GithubNestedImpl();
    }
    public GithubNested<A> withNewGithubLike( WebHookTrigger item){
    return new GithubNestedImpl(item);
    }
    public GithubNested<A> editGithub(){
    return withNewGithubLike(getGithub());
    }
    public A withNewGithub( Boolean allowEnv,  String secret){
    return withGithub(new WebHookTrigger(allowEnv, secret));
    }
    public ImageChangeTrigger getImageChange(){
    return this.imageChange!=null?this.imageChange.build():null;
    }
    public A withImageChange( ImageChangeTrigger imageChange){
    if (imageChange!=null){ this.imageChange= new ImageChangeTriggerBuilder(imageChange); _visitables.add(this.imageChange);} return (A) this;
    }
    public ImageChangeNested<A> withNewImageChange(){
    return new ImageChangeNestedImpl();
    }
    public ImageChangeNested<A> withNewImageChangeLike( ImageChangeTrigger item){
    return new ImageChangeNestedImpl(item);
    }
    public ImageChangeNested<A> editImageChange(){
    return withNewImageChangeLike(getImageChange());
    }
    public String getType(){
    return this.type;
    }
    public A withType( String type){
    this.type=type; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildTriggerPolicyFluentImpl that = (BuildTriggerPolicyFluentImpl) o;
if (generic != null ? !generic.equals(that.generic) :that.generic != null) return false;
if (github != null ? !github.equals(that.github) :that.github != null) return false;
if (imageChange != null ? !imageChange.equals(that.imageChange) :that.imageChange != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
return true;

    }

    public class GenericNestedImpl<N> extends WebHookTriggerFluentImpl<GenericNested<N>> implements GenericNested<N>{

        private final WebHookTriggerBuilder builder;
    
             GenericNestedImpl (){
        this.builder = new WebHookTriggerBuilder(this);
        }
             GenericNestedImpl ( WebHookTrigger item){
        this.builder = new WebHookTriggerBuilder(this, item);
        }
    
            public N endGeneric(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withGeneric(builder.build());
        }
    
}
    public class GithubNestedImpl<N> extends WebHookTriggerFluentImpl<GithubNested<N>> implements GithubNested<N>{

        private final WebHookTriggerBuilder builder;
    
             GithubNestedImpl (){
        this.builder = new WebHookTriggerBuilder(this);
        }
             GithubNestedImpl ( WebHookTrigger item){
        this.builder = new WebHookTriggerBuilder(this, item);
        }
    
            public N endGithub(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withGithub(builder.build());
        }
    
}
    public class ImageChangeNestedImpl<N> extends ImageChangeTriggerFluentImpl<ImageChangeNested<N>> implements ImageChangeNested<N>{

        private final ImageChangeTriggerBuilder builder;
    
             ImageChangeNestedImpl (){
        this.builder = new ImageChangeTriggerBuilder(this);
        }
             ImageChangeNestedImpl ( ImageChangeTrigger item){
        this.builder = new ImageChangeTriggerBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withImageChange(builder.build());
        }
            public N endImageChange(){
            return and();
        }
    
}


}
