package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.List;

public class ClusterPolicyBindingFluentImpl<A extends ClusterPolicyBindingFluent<A>> extends BaseFluent<A> implements ClusterPolicyBindingFluent<A>{

     String apiVersion;     String kind;     String lastModified;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<ObjectReference, ?> policyRef;     List<VisitableBuilder<NamedClusterRoleBinding, ?>> roleBindings = new ArrayList();
public ClusterPolicyBindingFluentImpl(){
    
}
public ClusterPolicyBindingFluentImpl( ClusterPolicyBinding instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withLastModified(instance.getLastModified()); this.withMetadata(instance.getMetadata()); this.withPolicyRef(instance.getPolicyRef()); this.withRoleBindings(instance.getRoleBindings()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public String getLastModified(){
    return this.lastModified;
    }
    public A withLastModified( String lastModified){
    this.lastModified=lastModified; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public ObjectReference getPolicyRef(){
    return this.policyRef!=null?this.policyRef.build():null;
    }
    public A withPolicyRef( ObjectReference policyRef){
    if (policyRef!=null){ this.policyRef= new ObjectReferenceBuilder(policyRef); _visitables.add(this.policyRef);} return (A) this;
    }
    public PolicyRefNested<A> withNewPolicyRef(){
    return new PolicyRefNestedImpl();
    }
    public PolicyRefNested<A> withNewPolicyRefLike( ObjectReference item){
    return new PolicyRefNestedImpl(item);
    }
    public PolicyRefNested<A> editPolicyRef(){
    return withNewPolicyRefLike(getPolicyRef());
    }
    public A addToRoleBindings( NamedClusterRoleBinding ...items){
    for (NamedClusterRoleBinding item : items) {NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);_visitables.add(builder);this.roleBindings.add(builder);} return (A)this;
    }
    public A removeFromRoleBindings( NamedClusterRoleBinding ...items){
    for (NamedClusterRoleBinding item : items) {NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);_visitables.remove(builder);this.roleBindings.remove(builder);} return (A)this;
    }
    public List<NamedClusterRoleBinding> getRoleBindings(){
    return build(roleBindings);
    }
    public A withRoleBindings( List<NamedClusterRoleBinding> roleBindings){
    this.roleBindings.clear();if (roleBindings != null) {for (NamedClusterRoleBinding item : roleBindings){this.addToRoleBindings(item);}} return (A) this;
    }
    public A withRoleBindings( NamedClusterRoleBinding ...roleBindings){
    this.roleBindings.clear(); if (roleBindings != null) {for (NamedClusterRoleBinding item :roleBindings){ this.addToRoleBindings(item);}} return (A) this;
    }
    public RoleBindingsNested<A> addNewRoleBinding(){
    return new RoleBindingsNestedImpl();
    }
    public RoleBindingsNested<A> addNewRoleBindingLike( NamedClusterRoleBinding item){
    return new RoleBindingsNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterPolicyBindingFluentImpl that = (ClusterPolicyBindingFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (policyRef != null ? !policyRef.equals(that.policyRef) :that.policyRef != null) return false;
if (roleBindings != null ? !roleBindings.equals(that.roleBindings) :that.roleBindings != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ClusterPolicyBindingFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class PolicyRefNestedImpl<N> extends ObjectReferenceFluentImpl<PolicyRefNested<N>> implements PolicyRefNested<N>{

        private final ObjectReferenceBuilder builder;
    
             PolicyRefNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             PolicyRefNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endPolicyRef(){
            return and();
        }
            public N and(){
            return (N) ClusterPolicyBindingFluentImpl.this.withPolicyRef(builder.build());
        }
    
}
    public class RoleBindingsNestedImpl<N> extends NamedClusterRoleBindingFluentImpl<RoleBindingsNested<N>> implements RoleBindingsNested<N>{

        private final NamedClusterRoleBindingBuilder builder;
    
             RoleBindingsNestedImpl (){
        this.builder = new NamedClusterRoleBindingBuilder(this);
        }
             RoleBindingsNestedImpl ( NamedClusterRoleBinding item){
        this.builder = new NamedClusterRoleBindingBuilder(this, item);
        }
    
            public N endRoleBinding(){
            return and();
        }
            public N and(){
            return (N) ClusterPolicyBindingFluentImpl.this.addToRoleBindings(builder.build());
        }
    
}


}
