package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ClusterRoleScopeRestrictionFluentImpl<A extends ClusterRoleScopeRestrictionFluent<A>> extends BaseFluent<A> implements ClusterRoleScopeRestrictionFluent<A>{

     Boolean allowEscalation;     List<String> namespaces = new ArrayList();     List<String> roleNames = new ArrayList();
public ClusterRoleScopeRestrictionFluentImpl(){
    
}
public ClusterRoleScopeRestrictionFluentImpl( ClusterRoleScopeRestriction instance ){
    this.withAllowEscalation(instance.getAllowEscalation()); this.withNamespaces(instance.getNamespaces()); this.withRoleNames(instance.getRoleNames()); 
}

    public Boolean isAllowEscalation(){
    return this.allowEscalation;
    }
    public A withAllowEscalation( Boolean allowEscalation){
    this.allowEscalation=allowEscalation; return (A) this;
    }
    public A addToNamespaces( String ...items){
    for (String item : items) {this.namespaces.add(item);} return (A)this;
    }
    public A removeFromNamespaces( String ...items){
    for (String item : items) {this.namespaces.remove(item);} return (A)this;
    }
    public List<String> getNamespaces(){
    return this.namespaces;
    }
    public A withNamespaces( List<String> namespaces){
    this.namespaces.clear();if (namespaces != null) {for (String item : namespaces){this.addToNamespaces(item);}} return (A) this;
    }
    public A withNamespaces( String ...namespaces){
    this.namespaces.clear(); if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }
    public A addToRoleNames( String ...items){
    for (String item : items) {this.roleNames.add(item);} return (A)this;
    }
    public A removeFromRoleNames( String ...items){
    for (String item : items) {this.roleNames.remove(item);} return (A)this;
    }
    public List<String> getRoleNames(){
    return this.roleNames;
    }
    public A withRoleNames( List<String> roleNames){
    this.roleNames.clear();if (roleNames != null) {for (String item : roleNames){this.addToRoleNames(item);}} return (A) this;
    }
    public A withRoleNames( String ...roleNames){
    this.roleNames.clear(); if (roleNames != null) {for (String item :roleNames){ this.addToRoleNames(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterRoleScopeRestrictionFluentImpl that = (ClusterRoleScopeRestrictionFluentImpl) o;
if (allowEscalation != null ? !allowEscalation.equals(that.allowEscalation) :that.allowEscalation != null) return false;
if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
if (roleNames != null ? !roleNames.equals(that.roleNames) :that.roleNames != null) return false;
return true;

    }



}
