package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class DeploymentConfigSpecBuilder extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder> implements VisitableBuilder<DeploymentConfigSpec,DeploymentConfigSpecBuilder>{

     DeploymentConfigSpecFluent<?> fluent;
public DeploymentConfigSpecBuilder(){
    this(new DeploymentConfigSpec());
}
public DeploymentConfigSpecBuilder( DeploymentConfigSpecFluent<?> fluent ){
    this(fluent, new DeploymentConfigSpec());
}
public DeploymentConfigSpecBuilder( DeploymentConfigSpecFluent<?> fluent , DeploymentConfigSpec instance ){
    this.fluent = fluent; fluent.withReplicas(instance.getReplicas()); fluent.withSelector(instance.getSelector()); fluent.withStrategy(instance.getStrategy()); fluent.withTemplate(instance.getTemplate()); fluent.withTest(instance.getTest()); fluent.withTriggers(instance.getTriggers()); 
}
public DeploymentConfigSpecBuilder( DeploymentConfigSpec instance ){
    this.fluent = this; this.withReplicas(instance.getReplicas()); this.withSelector(instance.getSelector()); this.withStrategy(instance.getStrategy()); this.withTemplate(instance.getTemplate()); this.withTest(instance.getTest()); this.withTriggers(instance.getTriggers()); 
}

public DeploymentConfigSpec build(){
    DeploymentConfigSpec buildable = new DeploymentConfigSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.isTest(),fluent.getTriggers());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeploymentConfigSpecBuilder that = (DeploymentConfigSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
