package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeploymentConfigStatusFluentImpl<A extends DeploymentConfigStatusFluent<A>> extends BaseFluent<A> implements DeploymentConfigStatusFluent<A>{

     VisitableBuilder<DeploymentDetails, ?> details;     Integer latestVersion;     Long observedGeneration;
public DeploymentConfigStatusFluentImpl(){
    
}
public DeploymentConfigStatusFluentImpl( DeploymentConfigStatus instance ){
    this.withDetails(instance.getDetails()); this.withLatestVersion(instance.getLatestVersion()); this.withObservedGeneration(instance.getObservedGeneration()); 
}

    public DeploymentDetails getDetails(){
    return this.details!=null?this.details.build():null;
    }
    public A withDetails( DeploymentDetails details){
    if (details!=null){ this.details= new DeploymentDetailsBuilder(details); _visitables.add(this.details);} return (A) this;
    }
    public DetailsNested<A> withNewDetails(){
    return new DetailsNestedImpl();
    }
    public DetailsNested<A> withNewDetailsLike( DeploymentDetails item){
    return new DetailsNestedImpl(item);
    }
    public DetailsNested<A> editDetails(){
    return withNewDetailsLike(getDetails());
    }
    public Integer getLatestVersion(){
    return this.latestVersion;
    }
    public A withLatestVersion( Integer latestVersion){
    this.latestVersion=latestVersion; return (A) this;
    }
    public Long getObservedGeneration(){
    return this.observedGeneration;
    }
    public A withObservedGeneration( Long observedGeneration){
    this.observedGeneration=observedGeneration; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl) o;
if (details != null ? !details.equals(that.details) :that.details != null) return false;
if (latestVersion != null ? !latestVersion.equals(that.latestVersion) :that.latestVersion != null) return false;
if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
return true;

    }

    public class DetailsNestedImpl<N> extends DeploymentDetailsFluentImpl<DetailsNested<N>> implements DetailsNested<N>{

        private final DeploymentDetailsBuilder builder;
    
             DetailsNestedImpl (){
        this.builder = new DeploymentDetailsBuilder(this);
        }
             DetailsNestedImpl ( DeploymentDetails item){
        this.builder = new DeploymentDetailsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentConfigStatusFluentImpl.this.withDetails(builder.build());
        }
            public N endDetails(){
            return and();
        }
    
}


}
