package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface DeploymentStrategyFluent<A extends DeploymentStrategyFluent<A>> extends Fluent<A>{


    public A addToAnnotations( String key,  String value);    public A addToAnnotations( Map<String, String> map);    public A removeFromAnnotations( String key);    public A removeFromAnnotations( Map<String, String> map);    public Map<String, String> getAnnotations();    public A withAnnotations( Map<String, String> annotations);    public CustomDeploymentStrategyParams getCustomParams();    public A withCustomParams( CustomDeploymentStrategyParams customParams);    public CustomParamsNested<A> withNewCustomParams();    public CustomParamsNested<A> withNewCustomParamsLike( CustomDeploymentStrategyParams item);    public CustomParamsNested<A> editCustomParams();    public A addToLabels( String key,  String value);    public A addToLabels( Map<String, String> map);    public A removeFromLabels( String key);    public A removeFromLabels( Map<String, String> map);    public Map<String, String> getLabels();    public A withLabels( Map<String, String> labels);    public RecreateDeploymentStrategyParams getRecreateParams();    public A withRecreateParams( RecreateDeploymentStrategyParams recreateParams);    public RecreateParamsNested<A> withNewRecreateParams();    public RecreateParamsNested<A> withNewRecreateParamsLike( RecreateDeploymentStrategyParams item);    public RecreateParamsNested<A> editRecreateParams();    public ResourceRequirements getResources();    public A withResources( ResourceRequirements resources);    public ResourcesNested<A> withNewResources();    public ResourcesNested<A> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<A> editResources();    public RollingDeploymentStrategyParams getRollingParams();    public A withRollingParams( RollingDeploymentStrategyParams rollingParams);    public RollingParamsNested<A> withNewRollingParams();    public RollingParamsNested<A> withNewRollingParamsLike( RollingDeploymentStrategyParams item);    public RollingParamsNested<A> editRollingParams();    public String getType();    public A withType( String type);
    public interface CustomParamsNested<N> extends Nested<N>,CustomDeploymentStrategyParamsFluent<CustomParamsNested<N>>{
            public N endCustomParams();            public N and();        
}

    public interface RecreateParamsNested<N> extends Nested<N>,RecreateDeploymentStrategyParamsFluent<RecreateParamsNested<N>>{
            public N and();            public N endRecreateParams();        
}

    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface RollingParamsNested<N> extends Nested<N>,RollingDeploymentStrategyParamsFluent<RollingParamsNested<N>>{
            public N and();            public N endRollingParams();        
}


}
