package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface IdentityFluent<A extends IdentityFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public A addToExtra( String key,  String value);    public A addToExtra( Map<String, String> map);    public A removeFromExtra( String key);    public A removeFromExtra( Map<String, String> map);    public Map<String, String> getExtra();    public A withExtra( Map<String, String> extra);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public String getProviderName();    public A withProviderName( String providerName);    public String getProviderUserName();    public A withProviderUserName( String providerUserName);    public ObjectReference getUser();    public A withUser( ObjectReference user);    public UserNested<A> withNewUser();    public UserNested<A> withNewUserLike( ObjectReference item);    public UserNested<A> editUser();
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface UserNested<N> extends Nested<N>,ObjectReferenceFluent<UserNested<N>>{
            public N and();            public N endUser();        
}


}
