package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class ImageChangeTriggerFluentImpl<A extends ImageChangeTriggerFluent<A>> extends BaseFluent<A> implements ImageChangeTriggerFluent<A>{

     VisitableBuilder<ObjectReference, ?> from;     String lastTriggeredImageID;
public ImageChangeTriggerFluentImpl(){
    
}
public ImageChangeTriggerFluentImpl( ImageChangeTrigger instance ){
    this.withFrom(instance.getFrom()); this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
}

    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public A withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }
    public FromNested<A> withNewFrom(){
    return new FromNestedImpl();
    }
    public FromNested<A> withNewFromLike( ObjectReference item){
    return new FromNestedImpl(item);
    }
    public FromNested<A> editFrom(){
    return withNewFromLike(getFrom());
    }
    public String getLastTriggeredImageID(){
    return this.lastTriggeredImageID;
    }
    public A withLastTriggeredImageID( String lastTriggeredImageID){
    this.lastTriggeredImageID=lastTriggeredImageID; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageChangeTriggerFluentImpl that = (ImageChangeTriggerFluentImpl) o;
if (from != null ? !from.equals(that.from) :that.from != null) return false;
if (lastTriggeredImageID != null ? !lastTriggeredImageID.equals(that.lastTriggeredImageID) :that.lastTriggeredImageID != null) return false;
return true;

    }

    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<FromNested<N>> implements FromNested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             FromNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) ImageChangeTriggerFluentImpl.this.withFrom(builder.build());
        }
    
}


}
