package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public A addToDockerImageLayers( ImageLayer ...items);    public A removeFromDockerImageLayers( ImageLayer ...items);    public List<ImageLayer> getDockerImageLayers();    public A withDockerImageLayers( List<ImageLayer> dockerImageLayers);    public A withDockerImageLayers( ImageLayer ...dockerImageLayers);    public DockerImageLayersNested<A> addNewDockerImageLayer();    public DockerImageLayersNested<A> addNewDockerImageLayerLike( ImageLayer item);    public A addNewDockerImageLayer( String name,  Long size);    public String getDockerImageManifest();    public A withDockerImageManifest( String dockerImageManifest);    public HasMetadata getDockerImageMetadata();    public A withDockerImageMetadata( HasMetadata dockerImageMetadata);    public String getDockerImageMetadataVersion();    public A withDockerImageMetadataVersion( String dockerImageMetadataVersion);    public String getDockerImageReference();    public A withDockerImageReference( String dockerImageReference);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();
    public interface DockerImageLayersNested<N> extends Nested<N>,ImageLayerFluent<DockerImageLayersNested<N>>{
            public N and();            public N endDockerImageLayer();        
}

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
