package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ImageFluentImpl<A extends ImageFluent<A>> extends BaseFluent<A> implements ImageFluent<A>{

     String apiVersion;     List<VisitableBuilder<ImageLayer, ?>> dockerImageLayers = new ArrayList();     String dockerImageManifest;     HasMetadata dockerImageMetadata;     String dockerImageMetadataVersion;     String dockerImageReference;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;
public ImageFluentImpl(){
    
}
public ImageFluentImpl( Image instance ){
    this.withApiVersion(instance.getApiVersion()); this.withDockerImageLayers(instance.getDockerImageLayers()); this.withDockerImageManifest(instance.getDockerImageManifest()); this.withDockerImageMetadata(instance.getDockerImageMetadata()); this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); this.withDockerImageReference(instance.getDockerImageReference()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToDockerImageLayers( ImageLayer ...items){
    for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.add(builder);this.dockerImageLayers.add(builder);} return (A)this;
    }
    public A removeFromDockerImageLayers( ImageLayer ...items){
    for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.remove(builder);this.dockerImageLayers.remove(builder);} return (A)this;
    }
    public List<ImageLayer> getDockerImageLayers(){
    return build(dockerImageLayers);
    }
    public A withDockerImageLayers( List<ImageLayer> dockerImageLayers){
    this.dockerImageLayers.clear();if (dockerImageLayers != null) {for (ImageLayer item : dockerImageLayers){this.addToDockerImageLayers(item);}} return (A) this;
    }
    public A withDockerImageLayers( ImageLayer ...dockerImageLayers){
    this.dockerImageLayers.clear(); if (dockerImageLayers != null) {for (ImageLayer item :dockerImageLayers){ this.addToDockerImageLayers(item);}} return (A) this;
    }
    public DockerImageLayersNested<A> addNewDockerImageLayer(){
    return new DockerImageLayersNestedImpl();
    }
    public DockerImageLayersNested<A> addNewDockerImageLayerLike( ImageLayer item){
    return new DockerImageLayersNestedImpl(item);
    }
    public A addNewDockerImageLayer( String name,  Long size){
    return addToDockerImageLayers(new ImageLayer(name, size));
    }
    public String getDockerImageManifest(){
    return this.dockerImageManifest;
    }
    public A withDockerImageManifest( String dockerImageManifest){
    this.dockerImageManifest=dockerImageManifest; return (A) this;
    }
    public HasMetadata getDockerImageMetadata(){
    return this.dockerImageMetadata;
    }
    public A withDockerImageMetadata( HasMetadata dockerImageMetadata){
    this.dockerImageMetadata=dockerImageMetadata; return (A) this;
    }
    public String getDockerImageMetadataVersion(){
    return this.dockerImageMetadataVersion;
    }
    public A withDockerImageMetadataVersion( String dockerImageMetadataVersion){
    this.dockerImageMetadataVersion=dockerImageMetadataVersion; return (A) this;
    }
    public String getDockerImageReference(){
    return this.dockerImageReference;
    }
    public A withDockerImageReference( String dockerImageReference){
    this.dockerImageReference=dockerImageReference; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageFluentImpl that = (ImageFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (dockerImageLayers != null ? !dockerImageLayers.equals(that.dockerImageLayers) :that.dockerImageLayers != null) return false;
if (dockerImageManifest != null ? !dockerImageManifest.equals(that.dockerImageManifest) :that.dockerImageManifest != null) return false;
if (dockerImageMetadata != null &&dockerImageMetadata != this ? !dockerImageMetadata.equals(that.dockerImageMetadata) :that.dockerImageMetadata != null &&dockerImageMetadata != this ) return false;
if (dockerImageMetadataVersion != null ? !dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) :that.dockerImageMetadataVersion != null) return false;
if (dockerImageReference != null ? !dockerImageReference.equals(that.dockerImageReference) :that.dockerImageReference != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
return true;

    }

    public class DockerImageLayersNestedImpl<N> extends ImageLayerFluentImpl<DockerImageLayersNested<N>> implements DockerImageLayersNested<N>{

        private final ImageLayerBuilder builder;
    
             DockerImageLayersNestedImpl (){
        this.builder = new ImageLayerBuilder(this);
        }
             DockerImageLayersNestedImpl ( ImageLayer item){
        this.builder = new ImageLayerBuilder(this, item);
        }
    
            public N and(){
            return (N) ImageFluentImpl.this.addToDockerImageLayers(builder.build());
        }
            public N endDockerImageLayer(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ImageFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
